package com.biz.crm.dms.business.order.feerate.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 费用比例Dto
 * @author: rentao
 * @date: 2021/12/30 13:45
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DmsFeeRateDto", description = "费用比例dto")
public class DmsFeeRateDto extends TenantFlagOpDto {
  /** 费比类型 0 费用池 1 整单 */
  @ApiModelProperty(name = "feeType", value = "费比类型 0 费用池 1 整单（FeeTypeEnum）", required = true)
  private Integer feeType;

  /** 费用统计范围编码 */
  @ApiModelProperty(name = "feeStatisticsCode", value = "费用统计范围编码（OrderStatisticsElementConstant）常量", required = true)
  private String feeStatisticsCode;

  /** 费用统计范围名称 */
  @ApiModelProperty(name = "feeStatisticsName", value = "费用统计范围名称", required = true)
  private String feeStatisticsName;

  /** 销售额统计范围编码 */
  @ApiModelProperty(name = "saleStatisticsCode", value = "销售额统计范围编码（OrderStatisticsElementConstant）常量", required = true)
  private String saleStatisticsCode;

  /** 销售额统计范围名称 */
  @ApiModelProperty(name = "saleStatisticsName", value = "销售额统计范围名称", required = true)
  private String saleStatisticsName;

  /** 比例 （%） */
  @ApiModelProperty(name = "janTargetNum", value = "比例 （%）", required = true)
  private BigDecimal rate;

  /** 生效维度*/
  @ApiModelProperty(name = "demension", value = "生效维度 0 客户 1 组织", required = true)
  private Integer demension;

  /** 生效维度名称 */
  @ApiModelProperty(name = "demensionName", value = "生效维度名称", required = true)
  private String demensionName;

  /** 业务编码 生效维度为 0 客户 必填 */
  @ApiModelProperty(name = "businessCode", value = "业务编码 生效维度为 0 客户 必填")
  private String businessCode;

  /** 业务名称 生效维度为 0 客户 必填 */
  @ApiModelProperty(name = "businessName", value = "业务编码 生效维度为 0 客户 必填")
  private String businessName;
}
