package com.biz.crm.dms.business.order.feerate.sdk.strategy;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsOptimalFeePoolRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import java.util.List;
import org.apache.commons.lang3.Validate;

/**
 * @description: 生效维度策略类
 * @author: rentao
 * @date: 2022/6/8 15:32
 */
public interface DemensionStrategy {

  /**
   * 维度编码
   *
   * @author rentao
   * @date
   */
  Integer getDemensionCode();

  /**
   * 维度名称
   *
   * @author rentao
   * @date
   */
  String getDemensionName();

  /**
   * 维度优先级（必须保证唯一）
   *
   * @author rentao
   * @date
   */
  int getDemensionIndex();


  /**
   * 查询费比数据
   *
   * @author rentao
   * @date
   */
   List<DmsFeeRateVo> getByDemension(DmsOptimalFeePoolRateDto dmsOptimalFeePoolRateDto,FeeTypeEnum feeTypeEnum);


  /**
   * 验证数据
   *
   * @author rentao
   * @date
   */
   void validateDmsFeeRate(DmsFeeRateDto dmsFeeRateDto);


}
