package com.biz.crm.dms.business.order.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.local.entity.HistoryViewQueryConfig;
import com.biz.crm.dms.business.order.local.service.HistoryViewQueryConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 历史查看的查询配置(HistoryViewQueryConfig)表相关的http接口
 *
 * @author makejava
 * @since 2022-04-07 17:14:33
 */
@RestController
@RequestMapping("/v1/order/historyViewQueryConfig")
@Slf4j
@Api(tags = "订单模块：HistoryViewQueryConfig：订单购买历史查看的查询配置")
public class HistoryViewQueryConfigController {

  /**
   * 服务对象
   */
  @Autowired(required = false)
  private HistoryViewQueryConfigService historyViewQueryConfigService;

  /**
   * 通过当前登录用户查询
   * -- 经销商用户使用
   * -- 经销商的租户编码不一定是经销商编码
   *
   * @return 单条数据
   */
  @ApiOperation(value = "通过登录租户查询单条数据")
  @GetMapping("findByCurrentCustomerCode")
  public Result<HistoryViewQueryConfig> findByCurrentCustomerCode() {
    try {
      HistoryViewQueryConfig historyViewQueryConfig = this.historyViewQueryConfigService.findByCurrentCustomerCode();
      return Result.ok(historyViewQueryConfig);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param historyViewQueryConfig 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<HistoryViewQueryConfig> update(@ApiParam(name = "historyViewQueryConfig", value = "历史查看的查询配置") @RequestBody HistoryViewQueryConfig historyViewQueryConfig) {
    try {
      HistoryViewQueryConfig result = this.historyViewQueryConfigService.update(historyViewQueryConfig);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   * - 因为网关问题未修复好
   * - 为小程序不能发起patch请求
   *
   * @param historyViewQueryConfig 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PostMapping("updateTurnPatch")
  public Result<HistoryViewQueryConfig> updateTurnPatch(@ApiParam(name = "historyViewQueryConfig", value = "历史查看的查询配置") @RequestBody HistoryViewQueryConfig historyViewQueryConfig) {
    return this.update(historyViewQueryConfig);
  }

}
