package com.biz.crm.dms.business.order.local.controller;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.sdk.dto.OrderPreviewDto;
import com.biz.crm.dms.business.order.sdk.service.OrderPreviewService;
import com.biz.crm.dms.business.order.sdk.vo.OrderPreviewVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 订单优惠政策预览相关的http接口
 *
 * @author hefan
 * @since 2022-01-08 15:13:04
 */
@RestController
@RequestMapping("/v1/order/preview")
@Slf4j
@Api(tags = "订单模块：OrderPreviewVo：订单优惠政策预览")
public class OrderPreviewController {

  @Autowired(required = false)
  private OrderPreviewService orderPreviewService;

  /**
   * hf：
   * 订单预览
   * -- 不会保存任何数据，包括暂存数据
   * -- 前端不要传货补的信息进来，不会处理的
   */
  @ApiOperation(value = "订单预览")
  @PostMapping("handlePreview")
  public Result<OrderPreviewVo> handlePreview(@ApiParam(name = "order", value = "订单主信息") @RequestBody OrderPreviewDto order) {
    try {
      log.info("/v1/order/preview/handlePreview:{}", JSON.toJSONString(order));
      OrderPreviewVo result = this.orderPreviewService.handlePreview(order);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 订单预览-客户为当前登录经销商
   * -- 不会保存任何数据，包括暂存数据
   * -- 前端不要传货补的信息进来，不会处理的
   */
  @ApiOperation(value = "订单预览-客户为当前登录经销商")
  @PostMapping("handlePreviewByCurrentCustomer")
  public Result<OrderPreviewVo> handlePreviewByCurrentCustomer(@ApiParam(name = "order", value = "订单主信息") @RequestBody OrderPreviewDto order) {
    try {
      log.info("/v1/order/preview/handlePreviewByCurrentCustomer:{}", JSON.toJSONString(order));
      OrderPreviewVo result = this.orderPreviewService.handlePreviewByCurrentCustomer(order);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 订单预览-再来一单
   *
   * @param orderId 订单ID
   * @return {@link Result}<{@link OrderPreviewVo}>
   */
  @ApiOperation(value = "订单预览-再来一单")
  @GetMapping("handlePreviewByOrderId")
  public Result<OrderPreviewVo> handlePreviewByOrderId(@ApiParam(name = "orderId", value = "订单ID") @RequestParam String orderId) {
    try {
      log.info("/v1/order/preview/handlePreviewByOrderId:{}", orderId);
      OrderPreviewVo result = this.orderPreviewService.handlePreviewByOrderId(orderId);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
