package com.biz.crm.dms.business.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.AppEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 历史查看的查询配置
 *
 * @author hefan
 * @date 2022/04/06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_order_history_view_query_config")
@Table(name = "dms_order_history_view_query_config")
@ApiModel(value = "HistoryViewQueryConfig", description = "历史查看的查询配置")
@org.hibernate.annotations.Table(appliesTo = "dms_order_history_view_query_config", comment = "历史查看的查询配置")
public class HistoryViewQueryConfig extends AppEntity {
  private static final long serialVersionUID = -7768430607828764227L;

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  @TableField(value = "relate_code")
  @Column(name = "relate_code", length = 255, columnDefinition = "varchar(255) COMMENT '关联编码 【客户编码】'")
  private String relateCode;

  /**
   * 购买次数
   */
  @ApiModelProperty("购买次数")
  @TableField(value = "times")
  @Column(name = "times", length = 4, columnDefinition = "int(4) COMMENT '购买次数'")
  private Integer times;

}
