package com.biz.crm.dms.business.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.AppEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;

/**
 * 行上该扣项目
 * 单个商品行该扣减掉的金额
 * 一条信息就是一项该扣减的金额信息
 *
 * @author sunx
 * @since 2021-12-28 15:18:38
 */

@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_order_detail_pay")
@Table(name = "dms_order_detail_pay")
@ApiModel(value = "OrderDetailPay", description = "订单明细支付明细")
@org.hibernate.annotations.Table(appliesTo = "dms_order_detail_pay", comment = "订单明细支付明细")
public class OrderDetailPay extends AppEntity {
  private static final long serialVersionUID = -3094558750543633410L;

  /**
   * 明细编码
   */
  @ApiModelProperty("明细编码")
  @Column(name = "order_detail_code", length = 255, columnDefinition = "varchar(255) COMMENT '明细编码'")
  private String orderDetailCode;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  @Column(name = "order_code", length = 255, columnDefinition = "varchar(255) COMMENT '订单编码'")
  private String orderCode;

  /**
   * 该扣项目组的key
   */
  @ApiModelProperty("该扣项目组的key")
  @Column(name = "item_group_key", length = 32, columnDefinition = "varchar(32) COMMENT '该扣项目组的key'")
  private String itemGroupKey;

  /**
   * 该扣项目key
   */
  @ApiModelProperty("该扣项目key")
  @Column(name = "item_key", length = 32, columnDefinition = "varchar(32) COMMENT '该扣项目key'")
  private String itemKey;

  /**
   * 该扣项目名称
   */
  @ApiModelProperty("该扣项目名称")
  @Column(name = "item_name", length = 32, columnDefinition = "varchar(32) COMMENT '该扣项目名称'")
  private String itemName;

  /**
   * 该扣项目金额（分摊）
   */
  @ApiModelProperty("该扣项目金额（分摊）")
  @Column(name = "item_amount", columnDefinition = "decimal(20,4) COMMENT '该扣项目金额（分摊）'")
  private BigDecimal itemAmount;

  /**
   * 该扣项目金额数据的由来
   * 比如：【政策优惠】选择了的促销政策CODE
   */
  @ApiModelProperty("该扣项目金额数据的由来")
  @Column(name = "origin_data", length = 255, columnDefinition = "varchar(255) COMMENT '该扣项目金额数据的由来'")
  private String originData;

  /**
   * 该扣项目金额数据的由来的别名
   * 比如：【政策优惠】选择了的促销政策的名称
   */
  @ApiModelProperty("该扣项目金额数据的由来的别名")
  @Column(name = "origin_data_alias", length = 50, columnDefinition = "varchar(50) COMMENT '该扣项目金额数据的由来的别名'")
  private String originDataAlias;

  /**
   * 数据的由来【类型】
   * 比如：【政策优惠】的政策是整单的，还是行内商品的。
   */
  @ApiModelProperty("数据的由来【类型】")
  @Column(name = "origin_data_type", length = 20, columnDefinition = "varchar(20) COMMENT '数据的由来【类型】'")
  private String originDataType;

  /**
   * 订单明细实体类
   */
  @ApiModelProperty("订单明细实体类")
  @TableField(exist = false)
  @Transient
  private OrderDetail orderDetail;

}
