package com.biz.crm.dms.business.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.AppFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 购买历史
 *
 * @author hefan
 * @date 2022/04/06
 */
@Getter
@Setter
@Entity
@TableName("dms_order_purchase_history")
@Table(name = "dms_order_purchase_history", indexes = {
    @Index(name = "uk_app_code_relate_code_goods_code", columnList = "app_code,relate_code,goods_code", unique = true)
})
@ApiModel(value = "PurchaseHistory", description = "购买历史")
@org.hibernate.annotations.Table(appliesTo = "dms_order_purchase_history", comment = "购买历史")
public class PurchaseHistory extends AppFlagOpEntity {
  private static final long serialVersionUID = 6170480755159735443L;

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  @TableField(value = "relate_code")
  @Column(name = "relate_code", nullable = false ,length = 255, columnDefinition = "varchar(255) COMMENT '关联编码 【客户编码】'")
  private String relateCode;

  /**
   * 商品/物料编码
   */
  @ApiModelProperty("商品/物料编码")
  @Column(name = "goods_code", length = 64, columnDefinition = "varchar(64) COMMENT '商品/物料编码'")
  private String goodsCode;

  /**
   * 商品/物料名称
   */
  @ApiModelProperty("商品/物料名称")
  @Column(name = "goods_name", length = 100, columnDefinition = "varchar(100) COMMENT '商品/物料名称'")
  private String goodsName;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  @TableField(value = "spec")
  @Column(name = "spec", length = 64, columnDefinition = "varchar(64) COMMENT '规格'")
  private String spec;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  @TableField(value = "unite")
  @Column(name = "unite", length = 64, columnDefinition = "varchar(64) COMMENT '销售单位'")
  private String unite;

  /**
   * 购买次数
   */
  @ApiModelProperty("购买次数")
  @TableField(value = "times")
  @Column(name = "times", length = 4, columnDefinition = "int(4) COMMENT '购买次数'")
  private Integer times;

  /**
   * 可用状态  Y表示可用 ，N表示不可用
   */
  @ApiModelProperty("可用状态")
  @TableField(value = "is_usable")
  @Column(name = "is_usable", length = 64, columnDefinition = "VARCHAR(64) COMMENT '可用状态'")
  private String isUsable;

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof PurchaseHistory)) return false;
    PurchaseHistory that = (PurchaseHistory) o;
    if (!relateCode.equals(that.relateCode)) return false;
    if (!goodsCode.equals(that.goodsCode)) return false;
    return getAppCode().equals(that.getAppCode());
  }

  @Override
  public int hashCode() {
    int result = goodsCode.hashCode();
    result = 31 * result + relateCode.hashCode();
    result = 31 * result + getAppCode().hashCode();
    return result;
  }
}
