package com.biz.crm.dms.business.order.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.sdk.dto.CustomerOrderPageDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderPaginationDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 订单主信息(Order)表mybatis访问层
 *
 * @author makejava
 * @since 2022-01-08 15:13:09
 */
public interface OrderMapper extends BaseMapper<Order> {

  /**
   * 分页查询所有数据
   *
   * @param page  分页对象
   * @param orderPaginationDto 查询实体
   * @return 所有数据
   */
  public Page<Order> findByConditions(@Param("page") Page<Order> page, @Param("orderPaginationDto") OrderPaginationDto orderPaginationDto);

  /**
   * 根据订单编码集合查询订单详情
   *
   * @param orderCodes
   * @param appCode
   * @return
   */
  List<Order> findDetailByOrderCodes(@Param("orderCodes")List<String> orderCodes, @Param("appCode")String appCode);

  /**
   * 根据ID查询，包括子表信息
   *
   * @param id id
   * @return {@link Order}
   */
  Order findDetailById(@Param("id") String id);

  /**
   * 分页查询当前客户的数据
   *
   * @param page                 分页
   * @param customerOrderPageDto 客户订单分页dto
   * @return {@link Page}<{@link Order}>
   */
  Page<Order> findByCustomerOrderPageDto(@Param("page") Page<Order> page,  @Param("dto") CustomerOrderPageDto customerOrderPageDto);
}

