package com.biz.crm.dms.business.order.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.dms.business.order.local.entity.PurchaseHistory;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.sdk.dto.PurchaseHistoryPageDto;
import org.apache.ibatis.annotations.Param;

/**
 * 购买历史(PurchaseHistory)表mybatis访问层
 *
 * @author makejava
 * @since 2022-04-07 17:14:33
 */
public interface PurchaseHistoryMapper extends BaseMapper<PurchaseHistory> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param purchaseHistory 查询实体
   * @return 所有数据
  */
  public Page<PurchaseHistory> findByConditions(@Param("page") Page<PurchaseHistory> page, @Param("purchaseHistory") PurchaseHistoryPageDto purchaseHistory);
}

