package com.biz.crm.dms.business.order.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.order.local.entity.HistoryViewQueryConfig;
import com.biz.crm.dms.business.order.local.mapper.HistoryViewQueryConfigMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;


/**
 * 历史查看的查询配置(HistoryViewQueryConfig)表数据库访问层
 *
 * @author makejava
 * @since 2022-04-07 17:14:33
 */
@Component
public class HistoryViewQueryConfigRepository extends ServiceImpl<HistoryViewQueryConfigMapper, HistoryViewQueryConfig> {

  @Autowired(required = false)
  private HistoryViewQueryConfigMapper historyViewQueryConfigMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param HistoryViewQueryConfig 实体对象
   * @return
   */
  public Page<HistoryViewQueryConfig> findByConditions(Pageable pageable, HistoryViewQueryConfig HistoryViewQueryConfig) {
    Page<HistoryViewQueryConfig> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<HistoryViewQueryConfig> pageList = this.historyViewQueryConfigMapper.findByConditions(page, HistoryViewQueryConfig);
    return pageList;
  }

  /**
   * 根据业务关联编码查询
   *
   * @return {@link HistoryViewQueryConfig}
   * @param relateCode
   */
  public HistoryViewQueryConfig findByRelateCode(String relateCode) {
    return this.lambdaQuery()
        .eq(HistoryViewQueryConfig::getRelateCode, relateCode)
        .eq(HistoryViewQueryConfig::getAppCode, TenantUtils.getAppCode())
        .one();
  }
}

