package com.biz.crm.dms.business.order.local.repository;


import com.biz.crm.dms.business.order.local.entity.OrderDetailPay;
import com.biz.crm.dms.business.order.local.mapper.OrderDetailPayMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 订单明细支付明细(OrderDetailPay)表数据库访问层
 *
 * @author makejava
 * @since 2022-01-08 15:13:17
 */
@Component
public class OrderDetailPayRepository extends ServiceImpl<OrderDetailPayMapper, OrderDetailPay> {

  @Autowired(required = false)
  private OrderDetailPayMapper orderDetailPayMapper;

  /**
   * 分页查询数据
   *
   * @param pageable       分页对象
   * @param orderDetailPay 实体对象
   * @return
   */
  public Page<OrderDetailPay> findByConditions(Pageable pageable, OrderDetailPay orderDetailPay) {
    Page<OrderDetailPay> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<OrderDetailPay> pageList = orderDetailPayMapper.findByConditions(page, orderDetailPay);
    return pageList;
  }

  /**
   * 根据订单编码删除
   *
   * @param orderCode
   */
  public void deleteByOrderCode(String orderCode) {
    this.lambdaUpdate()
        .eq(OrderDetailPay::getAppCode, TenantUtils.getAppCode())
        .eq(OrderDetailPay::getOrderCode, orderCode)
        .remove();
  }
}

