package com.biz.crm.dms.business.order.local.repository;


import com.biz.crm.dms.business.order.local.entity.OrderPay;
import com.biz.crm.dms.business.order.local.mapper.OrderPayMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 订单支付明细(OrderPay)表数据库访问层
 *
 * @author makejava
 * @since 2022-01-08 15:13:27
 */
@Component
public class OrderPayRepository extends ServiceImpl<OrderPayMapper, OrderPay> {

  @Autowired(required = false)
  private OrderPayMapper orderPayMapper;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param orderPay 实体对象
   * @return
   */
  public Page<OrderPay> findByConditions(Pageable pageable, OrderPay orderPay) {
    Page<OrderPay> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<OrderPay> pageList = orderPayMapper.findByConditions(page, orderPay);
    return pageList;
  }

  /**
   * 根据订单编码删除
   * @param orderCode
   */
  public void deleteByOrderCode(String orderCode) {
    this.lambdaUpdate()
        .eq(OrderPay::getAppCode, TenantUtils.getAppCode())
        .eq(OrderPay::getOrderCode, orderCode)
        .remove();
  }
}

