package com.biz.crm.dms.business.order.local.service;


import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderPay;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 订单支付明细(OrderPay)表服务接口
 *
 * @author makejava
 * @since 2022-01-08 15:13:24
 */
public interface OrderPayService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param orderPay 实体对象
   * @return
   */
  Page<OrderPay> findByConditions(Pageable pageable, OrderPay orderPay);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  OrderPay findById(String id);

  /**
   * 新增数据
   *
   * @param orderPay 实体对象
   * @return 新增结果
   */
  OrderPay create(OrderPay orderPay);

  /**
   * 修改新据
   *
   * @param orderPay 实体对象
   * @return 修改结果
   */
  OrderPay update(OrderPay orderPay);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 新增数据（批量）
   * @param order
   */
  void createBatch(Order order);

  /**
   * 根据订单编码删除
   *
   * @param orderCode
   */
  void deleteByOrderCode(String orderCode);
}

