package com.biz.crm.dms.business.order.local.service;


import com.biz.crm.dms.business.order.local.entity.PurchaseHistory;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.sdk.dto.PurchaseHistoryPageDto;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 购买历史(PurchaseHistory)表服务接口
 *
 * @author makejava
 * @since 2022-04-07 17:14:33
 */
public interface PurchaseHistoryService{

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param purchaseHistory 实体对象
   * @return
   */
  Page<PurchaseHistory> findByConditions(Pageable pageable, PurchaseHistoryPageDto purchaseHistory);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  PurchaseHistory findById(String id);
  
   /**
   * 新增数据
   * @param purchaseHistory 实体对象
   * @return 新增结果
   */
  PurchaseHistory create(PurchaseHistory purchaseHistory);
  
   /**
   * 修改新据
   * @param purchaseHistory 实体对象
   * @return 修改结果
   */
  PurchaseHistory update(PurchaseHistory purchaseHistory);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 通过商品编码查询
   * @param code
   */
  List<PurchaseHistory> findByGoodsCode(String code);

  /**
   * 通过商品编码和可用状态，改变可用状态
   * @param goodsCode
   */
  void updateUsableStatus(String goodsCode,String isUsable);

  /**
   * 商品购买次数自增，（原子性)
   *
   * @param purchaseHistory 购买历史
   * @return {@link PurchaseHistory}
   */
  List<PurchaseHistory> handleIncrement(List<PurchaseHistory> purchaseHistory);

  /**
   * 通过商品编码更新商品基本信息
   * @param purchaseHistory
   */
  void updateByProductCode(PurchaseHistory purchaseHistory);
}

