package com.biz.crm.dms.business.order.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.order.local.entity.HistoryViewQueryConfig;
import com.biz.crm.dms.business.order.local.repository.HistoryViewQueryConfigRepository;
import com.biz.crm.dms.business.order.local.service.HistoryViewQueryConfigService;
import com.biz.crm.dms.business.order.sdk.constant.PurchaseHistoryConstant;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 历史查看的查询配置(HistoryViewQueryConfig)表服务实现类
 *
 * @author makejava
 * @since 2022-04-07 17:14:33
 */
@Service("HistoryViewQueryConfigService")
public class HistoryViewQueryConfigServiceImpl implements HistoryViewQueryConfigService {

  @Autowired(required = false)
  private HistoryViewQueryConfigRepository historyViewQueryConfigRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 分页查询数据
   *
   * @param pageable               分页对象
   * @param historyViewQueryConfig 实体对象
   * @return
   */
  @Override
  public Page<HistoryViewQueryConfig> findByConditions(Pageable pageable, HistoryViewQueryConfig historyViewQueryConfig) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(historyViewQueryConfig)) {
      historyViewQueryConfig = new HistoryViewQueryConfig();
    }
    historyViewQueryConfig.setAppCode(TenantUtils.getAppCode());
    return this.historyViewQueryConfigRepository.findByConditions(pageable, historyViewQueryConfig);
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public HistoryViewQueryConfig findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.historyViewQueryConfigRepository.getById(id);
  }

  /**
   * 新增数据
   *
   * @param historyViewQueryConfig 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public HistoryViewQueryConfig create(HistoryViewQueryConfig historyViewQueryConfig) {
    this.createValidate(historyViewQueryConfig);
    historyViewQueryConfig.setAppCode(TenantUtils.getAppCode());
    historyViewQueryConfig.setTenantCode(TenantUtils.getTenantCode());
    this.historyViewQueryConfigRepository.saveOrUpdate(historyViewQueryConfig);
    return historyViewQueryConfig;
  }

  /**
   * 修改新据
   *
   * @param historyViewQueryConfig 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public HistoryViewQueryConfig update(HistoryViewQueryConfig historyViewQueryConfig) {
    this.updateValidate(historyViewQueryConfig);
    LoginUserDetailsForEMS loginUserDetails = loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
    HistoryViewQueryConfig config = this.historyViewQueryConfigRepository.findByRelateCode(loginUserDetails.getCustomerCode());
    historyViewQueryConfig.setTenantCode(TenantUtils.getTenantCode());
    historyViewQueryConfig.setAppCode(TenantUtils.getAppCode());
    if (Objects.nonNull(config)) {
      historyViewQueryConfig.setId(config.getId());
    }
    historyViewQueryConfig.setRelateCode(loginUserDetails.getCustomerCode());
    this.historyViewQueryConfigRepository.saveOrUpdate(historyViewQueryConfig);
    return historyViewQueryConfig;
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.historyViewQueryConfigRepository.removeByIds(idList);
  }

  @Override
  public HistoryViewQueryConfig findByCurrentCustomerCode() {
    LoginUserDetailsForEMS loginUserDetails = loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
    HistoryViewQueryConfig config = this.historyViewQueryConfigRepository.findByRelateCode(loginUserDetails.getCustomerCode());
    if (Objects.isNull(config)) {
      config = new HistoryViewQueryConfig();
      config.setTimes(PurchaseHistoryConstant.defaultTimes);
    }
    return config;
  }

  /**
   * 创建验证
   *
   * @param historyViewQueryConfig
   */
  private void createValidate(HistoryViewQueryConfig historyViewQueryConfig) {
    Validate.notNull(historyViewQueryConfig, "新增时，对象信息不能为空！");
    historyViewQueryConfig.setId(null);
    Validate.notBlank(historyViewQueryConfig.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(historyViewQueryConfig.getRelateCode(), "新增数据时，关联编号不能为空！");

  }

  /**
   * 修改验证
   *
   * @param historyViewQueryConfig
   */
  private void updateValidate(HistoryViewQueryConfig historyViewQueryConfig) {
    Validate.notNull(historyViewQueryConfig, "修改时，对象信息不能为空！");
    Validate.notNull(historyViewQueryConfig.getTimes(), "修改时，购买次数不能为空！");
    Integer times = historyViewQueryConfig.getTimes();
    int compare = times.compareTo(Integer.valueOf(0));
    Validate.isTrue(compare > 0, "修改时，购买次数不能小于等于0");
  }
}

