package com.biz.crm.dms.business.order.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.repository.OrderRepository;
import com.biz.crm.dms.business.order.sdk.service.OrderStatusStatisticsVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderStatusStatisticsVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 订单状态统计服务impl
 *
 * @author hefan
 * @date 2022/04/13
 */
@Service
public class OrderStatusStatisticsVoServiceImpl implements OrderStatusStatisticsVoService {

  @Autowired(required = false)
  private OrderRepository orderRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public List<OrderStatusStatisticsVo> findByCurrentCustomer() {
    List<OrderStatusStatisticsVo> orderStatusStatisticsVoList = Lists.newArrayList();
    LoginUserDetailsForEMS loginDetails = loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
    String customerCode = loginDetails.getCustomerCode();
    String customerName = loginDetails.getCustomerName();
    List<String> orderStatusList = Lists.newArrayList(
        OrderStatusEnum.STAGING.getDictCode(),
        OrderStatusEnum.WAIT_SHIPPED.getDictCode(),
        OrderStatusEnum.PART_SHIPPED.getDictCode(),
        OrderStatusEnum.REJECTED.getDictCode()
    );
    orderStatusList.forEach(o -> {
      OrderStatusStatisticsVo orderStatusStatisticsVo = new OrderStatusStatisticsVo();
      orderStatusStatisticsVo.setOrderStatus(o);
      orderStatusStatisticsVo.setOrderStatusDesc(OrderStatusEnum.findByCode(o).getValue());
      orderStatusStatisticsVo.setOrderCount(0);
      orderStatusStatisticsVoList.add(orderStatusStatisticsVo);
    });
    List<Order> list = orderRepository.findByRelateCodeAndOrderStatusIn(customerCode, orderStatusList);
    Map<String, List<Order>> orderStatusMap = list.stream().collect(Collectors.groupingBy(Order::getOrderStatus));
    orderStatusStatisticsVoList.forEach(o -> {
      List<Order> orders = orderStatusMap.get(o.getOrderStatus());
      o.setRelateCode(customerCode);
      o.setRelateName(customerName);
      if(!CollectionUtils.isEmpty(orders)) {
        o.setOrderCount(orders.size());
      }
    });
    return orderStatusStatisticsVoList;
  }
}
