package com.biz.crm.dms.business.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.service.OrderService;
import com.biz.crm.dms.business.order.sdk.dto.OrderPaginationDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderUnshippedPageDto;
import com.biz.crm.dms.business.order.sdk.service.OrderUnshippedVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderUnshippedVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

/**
 * The type Order unshipped vo service.
 * @author he fan
 */
@Service
public class OrderUnshippedVoServiceImpl implements OrderUnshippedVoService {

  @Autowired(required = false)
  private OrderService orderService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<OrderUnshippedVo> findByOrderUnshippedPageDto(Pageable pageable, OrderUnshippedPageDto orderUnshippedPageDto) {
    if (Objects.isNull(orderUnshippedPageDto)) {
      orderUnshippedPageDto = new OrderUnshippedPageDto();
    }
    OrderPaginationDto order = new OrderPaginationDto();
    order.setOrderCategory(orderUnshippedPageDto.getOrderCategory());
    order.setOrderCode(orderUnshippedPageDto.getOrderCode());
    order.setOrderCodes(orderUnshippedPageDto.getOrderCodes());
    order.setRelateCode(orderUnshippedPageDto.getRelateCode());
    order.setRelateName(orderUnshippedPageDto.getRelateName());
    order.setOrderStatus(orderUnshippedPageDto.getOrderStatus());
    order.setOrderType(orderUnshippedPageDto.getOrderType());
    Page<Order> orderPage = orderService.findByConditions(pageable, order);
    List<Order> records = orderPage.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return null;
    }
    List<OrderUnshippedVo> orderUnshippedVos = (List<OrderUnshippedVo>) this.nebulaToolkitService.copyCollectionByBlankList(records, Order.class, OrderUnshippedVo.class, HashSet.class, LinkedList.class);
    Page<OrderUnshippedVo> orderUnshippedVoPage = new Page<>(orderPage.getCurrent(), orderPage.getSize(), orderPage.getTotal());
    orderUnshippedVoPage.setRecords(orderUnshippedVos);
    return orderUnshippedVoPage;
  }

}
