/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.controller;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.sdk.dto.OrderConfirmDto;
import com.biz.crm.dms.business.order.sdk.service.OrderConfirmService;
import com.biz.crm.dms.business.order.sdk.vo.OrderConfirmVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/order/confirm"})
@Api(tags={"\u8ba2\u5355\u6a21\u5757\uff1aOrderConfirmVo\uff1a\u8ba2\u5355\u63d0\u4ea4\u786e\u8ba4"})
public class OrderConfirmController {
    private static final Logger log = LoggerFactory.getLogger(OrderConfirmController.class);
    @Autowired(required=false)
    private OrderConfirmService orderConfirmService;

    @ApiOperation(value="\u8ba2\u5355\u63d0\u4ea4")
    @PostMapping(value={"handleSubmit"})
    public Result<OrderConfirmVo> handleSubmit(@ApiParam(name="order", value="\u8ba2\u5355\u4e3b\u4fe1\u606f") @RequestBody OrderConfirmDto order) {
        try {
            log.info("/v1/order/confirm/handleSubmit:{}", (Object)JSON.toJSONString((Object)order));
            OrderConfirmVo result = this.orderConfirmService.handleSubmit(order, (List)Lists.newArrayList());
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8ba2\u5355\u786e\u8ba4")
    @PostMapping(value={"handleConfirm"})
    public Result<OrderConfirmVo> handleConfirm(@ApiParam(name="order", value="\u8ba2\u5355\u4e3b\u4fe1\u606f") @RequestBody OrderConfirmDto order) {
        try {
            log.info("/v1/order/confirm/handleConfirm:{}", (Object)JSON.toJSONString((Object)order));
            OrderConfirmVo result = this.orderConfirmService.handleConfirm(order);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u767b\u5f55\u5ba2\u6237\u53bb\u786e\u8ba4\u8ba2\u5355")
    @PostMapping(value={"handleConfirmByCurrentCustomer"})
    public Result<OrderConfirmVo> handleConfirmByCurrentCustomer(@ApiParam(name="order", value="\u8ba2\u5355\u4e3b\u4fe1\u606f") @RequestBody OrderConfirmDto order) {
        try {
            log.info("/v1/order/confirm/handleConfirmByCurrentCustomer:{}", (Object)JSON.toJSONString((Object)order));
            OrderConfirmVo result = this.orderConfirmService.handleConfirmByCurrentCustomer(order);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u767b\u5f55\u5ba2\u6237\u4f7f\u7528\u90e8\u5206\u8d39\u7528\u63d0\u4ea4\u8ba2\u5355")
    @PostMapping(value={"handlePartSubmitByCurrentCustomer"})
    public Result<OrderConfirmVo> handlePartSubmitByCurrentCustomer(@ApiParam(name="order", value="\u8ba2\u5355\u4e3b\u4fe1\u606f") @RequestBody OrderConfirmDto order) {
        try {
            log.info("/v1/order/confirm/handlePartSubmitByCurrentCustomer:{}", (Object)JSON.toJSONString((Object)order));
            OrderConfirmVo result = this.orderConfirmService.handlePartSubmitByCurrentCustomer(order);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

