/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.service.OrderService;
import com.biz.crm.dms.business.order.sdk.dto.CustomerOrderPageDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/order/order"})
@Api(tags={"\u8ba2\u5355\u6a21\u5757\uff1aOrder\uff1a\u8ba2\u5355\u4e3b\u4fe1\u606f"})
public class OrderController {
    private static final Logger log = LoggerFactory.getLogger(OrderController.class);
    @Autowired(required=false)
    private OrderService orderService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<Order>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="order", value="\u8ba2\u5355\u4e3b\u4fe1\u606f") OrderPaginationDto order) {
        try {
            Page<Order> page = this.orderService.findByConditions(pageable, order);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5f53\u524d\u5ba2\u6237\u7684\u6570\u636e")
    @GetMapping(value={"findByCustomerOrderPageDto"})
    public Result<Page<Order>> findByCustomerOrderPageDto(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="order", value="\u8ba2\u5355\u4e3b\u4fe1\u606f") CustomerOrderPageDto customerOrderPageDto) {
        try {
            Page<Order> page = this.orderService.findByCustomerOrderPageDto(pageable, customerOrderPageDto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e--\u6682\u5b58\u529f\u80fd\u4f7f\u7528")
    @PostMapping
    public Result<Order> create(@ApiParam(name="order", value="\u8ba2\u5355\u4e3b\u4fe1\u606f") @RequestBody Order order) {
        try {
            Order result = this.orderService.create(order);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<Order> update(@ApiParam(name="order", value="\u8ba2\u5355\u4e3b\u4fe1\u606f") @RequestBody Order order) {
        try {
            Order result = this.orderService.update(order);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> idList) {
        try {
            this.orderService.delete(idList);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u9000\u7684\u8ba2\u5355\uff08\u5b8c\u5168\u53d1\u8d27\u3001\u90e8\u5206\u53d1\u8d27\uff09")
    @GetMapping(value={"findRefundableByCustomerCode"})
    public Result<List<Order>> findRefundableByCustomerCode(@ApiParam(name="relateCode", value="\u5173\u8054\u7f16\u7801 \u3010\u5ba2\u6237\u7f16\u7801\u3011") String relateCode) {
        try {
            List<Order> list = this.orderService.findRefundableByCustomerCode(relateCode);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

