/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.local.entity.OrderFile;
import com.biz.crm.dms.business.order.local.service.OrderFileService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/orderFile/orderFile"})
@Api(tags={"\u8ba2\u5355\u6a21\u5757\uff1aOrderFile\uff1a\u8ba2\u5355\u9644\u4ef6\u4fe1\u606f"})
public class OrderFileController {
    private static final Logger log = LoggerFactory.getLogger(OrderFileController.class);
    @Autowired(required=false)
    private OrderFileService orderFileService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<OrderFile>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="orderFile", value="\u8ba2\u5355\u9644\u4ef6\u4fe1\u606f") OrderFile orderFile) {
        try {
            Page<OrderFile> page = this.orderFileService.findByConditions(pageable, orderFile);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<OrderFile> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            OrderFile orderFile = this.orderFileService.findById(id);
            return Result.ok((Object)((Object)orderFile));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<OrderFile> create(@ApiParam(name="orderFile", value="\u8ba2\u5355\u9644\u4ef6\u4fe1\u606f") @RequestBody OrderFile orderFile) {
        try {
            OrderFile result = this.orderFileService.create(orderFile);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<OrderFile> update(@ApiParam(name="orderFile", value="\u8ba2\u5355\u9644\u4ef6\u4fe1\u606f") @RequestBody OrderFile orderFile) {
        try {
            OrderFile result = this.orderFileService.update(orderFile);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> idList) {
        try {
            this.orderFileService.delete(idList);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

