/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.controller;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.sdk.dto.OrderPreviewDto;
import com.biz.crm.dms.business.order.sdk.service.OrderPreviewService;
import com.biz.crm.dms.business.order.sdk.vo.OrderPreviewVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/order/preview"})
@Api(tags={"\u8ba2\u5355\u6a21\u5757\uff1aOrderPreviewVo\uff1a\u8ba2\u5355\u4f18\u60e0\u653f\u7b56\u9884\u89c8"})
public class OrderPreviewController {
    private static final Logger log = LoggerFactory.getLogger(OrderPreviewController.class);
    @Autowired(required=false)
    private OrderPreviewService orderPreviewService;

    @ApiOperation(value="\u8ba2\u5355\u9884\u89c8")
    @PostMapping(value={"handlePreview"})
    public Result<OrderPreviewVo> handlePreview(@ApiParam(name="order", value="\u8ba2\u5355\u4e3b\u4fe1\u606f") @RequestBody OrderPreviewDto order) {
        try {
            log.info("/v1/order/preview/handlePreview:{}", (Object)JSON.toJSONString((Object)order));
            OrderPreviewVo result = this.orderPreviewService.handlePreview(order);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8ba2\u5355\u9884\u89c8-\u5ba2\u6237\u4e3a\u5f53\u524d\u767b\u5f55\u7ecf\u9500\u5546")
    @PostMapping(value={"handlePreviewByCurrentCustomer"})
    public Result<OrderPreviewVo> handlePreviewByCurrentCustomer(@ApiParam(name="order", value="\u8ba2\u5355\u4e3b\u4fe1\u606f") @RequestBody OrderPreviewDto order) {
        try {
            log.info("/v1/order/preview/handlePreviewByCurrentCustomer:{}", (Object)JSON.toJSONString((Object)order));
            OrderPreviewVo result = this.orderPreviewService.handlePreviewByCurrentCustomer(order);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8ba2\u5355\u9884\u89c8-\u518d\u6765\u4e00\u5355")
    @GetMapping(value={"handlePreviewByOrderId"})
    public Result<OrderPreviewVo> handlePreviewByOrderId(@ApiParam(name="orderId", value="\u8ba2\u5355ID") @RequestParam String orderId) {
        try {
            log.info("/v1/order/preview/handlePreviewByOrderId:{}", (Object)orderId);
            OrderPreviewVo result = this.orderPreviewService.handlePreviewByOrderId(orderId);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

