/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.notifier;

import com.biz.crm.common.message.sdk.dto.SysMessageDto;
import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import com.biz.crm.common.message.sdk.enums.MessageBusinessType;
import com.biz.crm.common.message.sdk.enums.MessageHandlerEnum;
import com.biz.crm.common.message.sdk.enums.MessageRelateType;
import com.biz.crm.common.message.sdk.enums.MessageTypeEnum;
import com.biz.crm.common.message.sdk.service.SendMessageVoService;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.repository.OrderRepository;
import com.biz.crm.dms.business.order.sdk.dto.OrderEventDto;
import com.biz.crm.dms.business.order.sdk.event.OrderLogEventListener;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerDockingVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.customer.user.sdk.service.CustomerUserRelateCustomerVoService;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelateCustomerVo;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrderLogEventListenerOfSystemMessage
implements OrderLogEventListener {
    @Autowired(required=false)
    private SendMessageVoService sendMessageVoService;
    @Autowired(required=false)
    private CustomerUserRelateCustomerVoService customerUserRelateCustomerVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private UserInfoVoService userInfoVoService;
    @Autowired(required=false)
    private OrderRepository orderRepository;

    public void onCreate(OrderEventDto eventDto) {
    }

    public void onClose(OrderEventDto orderEventDto) {
        OrderVo newest = orderEventDto.getNewest();
        String relateCode = newest.getRelateCode();
        SysMessageDto msg = new SysMessageDto();
        msg.setCode(MessageTypeEnum.CLOSE_ORDER.getDictCode());
        HashMap map = Maps.newHashMap();
        CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, relateCode);
        Validate.notNull((Object)customerVo, (String)"\u5173\u95ed\u8ba2\u5355\u65f6\uff0c\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\uff0c\u6ca1\u6709\u67e5\u5230\u5ba2\u6237\u4fe1\u606f", (Object[])new Object[0]);
        List dockingList = customerVo.getDockingList();
        if (!CollectionUtils.isEmpty((Collection)dockingList)) {
            HashSet<String> positionCodes = new HashSet<String>(dockingList.size());
            for (CustomerDockingVo customerDockingVo : dockingList) {
                String positionCode = customerDockingVo.getPositionCode();
                positionCodes.add(positionCode);
            }
            List userList = this.userInfoVoService.findByPositionCodes(positionCodes);
            if (!CollectionUtils.isEmpty((Collection)userList)) {
                LinkedList userItems = Lists.newLinkedList();
                for (UserInfoVo userInfoVo : userList) {
                    SysMessageItemDto dto1 = new SysMessageItemDto();
                    dto1.setBusinessCode(userInfoVo.getUserName());
                    dto1.setBusinessType(MessageBusinessType.BACKGROUND.getDictCode());
                    dto1.setRelateCode(newest.getId());
                    dto1.setRelateType(MessageRelateType.ORDER.getDictCode());
                    HashMap param1Map = Maps.newHashMap();
                    param1Map.put("orderCode", newest.getOrderCode());
                    dto1.setParamsMap((Map)param1Map);
                    userItems.add(dto1);
                }
                map.put(MessageHandlerEnum.CLOSE_ORDER_USER.getDictCode(), userItems);
            }
        }
        String createAccount = newest.getCreateAccount();
        List customerUserRelateCustomerVos = this.customerUserRelateCustomerVoService.findByCustomerCodes((List)Lists.newArrayList((Object[])new String[]{relateCode}));
        if (CollectionUtils.isEmpty((Collection)customerUserRelateCustomerVos)) {
            return;
        }
        Set userNames = customerUserRelateCustomerVos.stream().map(CustomerUserRelateCustomerVo::getUserName).collect(Collectors.toSet());
        LinkedList customerItems = Lists.newLinkedList();
        boolean isCustomerOrder = userNames.contains(createAccount);
        if (isCustomerOrder) {
            SysMessageItemDto dto2 = new SysMessageItemDto();
            dto2.setBusinessCode(createAccount);
            dto2.setBusinessType(MessageBusinessType.CUSTOMER.getDictCode());
            dto2.setRelateCode(newest.getId());
            dto2.setRelateType(MessageRelateType.ORDER.getDictCode());
            HashMap param2Map = Maps.newHashMap();
            param2Map.put("orderCode", newest.getOrderCode());
            dto2.setParamsMap((Map)param2Map);
            customerItems.add(dto2);
        } else {
            for (String userName : userNames) {
                SysMessageItemDto dto2 = new SysMessageItemDto();
                dto2.setBusinessCode(userName);
                dto2.setBusinessType(MessageBusinessType.CUSTOMER.getDictCode());
                dto2.setRelateCode(newest.getId());
                dto2.setRelateType(MessageRelateType.ORDER.getDictCode());
                HashMap param2Map = Maps.newHashMap();
                param2Map.put("orderCode", newest.getOrderCode());
                dto2.setParamsMap((Map)param2Map);
                customerItems.add(dto2);
            }
        }
        map.put(MessageHandlerEnum.CLOSE_ORDER_CUSTOMER.getDictCode(), customerItems);
        msg.setMap((Map)map);
        this.sendMessageVoService.send(msg);
    }

    @DynamicTaskService(cornExpression="0 0 1 * * ?", taskDesc="\u8ba2\u5355\u5ef6\u8fdf\u53d1\u8d27\u7684\u7cfb\u7edf\u6d88\u606f\u901a\u77e5")
    public void deliveryDelay() {
        Date last10DaysStartTime = this.last10DaysStartTime();
        List<Order> waitShippedOrders = this.orderRepository.findByOrderStatusAndCreateTimeLe(OrderStatusEnum.WAIT_SHIPPED, last10DaysStartTime);
        if (CollectionUtils.isEmpty(waitShippedOrders)) {
            return;
        }
        List customerCodes = waitShippedOrders.stream().map(Order::getRelateCode).collect(Collectors.toList());
        List customerVos = this.customerVoService.findByCustomerCodes(customerCodes);
        if (CollectionUtils.isEmpty((Collection)customerVos)) {
            return;
        }
        HashSet<String> positionCodes = new HashSet<String>();
        HashMap<String, LinkedList> customerCodeToPositionMap = new HashMap<String, LinkedList>(customerVos.size());
        for (CustomerVo customerVo : customerVos) {
            List dockingList = customerVo.getDockingList();
            if (CollectionUtils.isEmpty((Collection)dockingList)) continue;
            LinkedList positionCodeList = Lists.newLinkedList();
            for (CustomerDockingVo dockingVo : dockingList) {
                positionCodes.add(dockingVo.getPositionCode());
                positionCodeList.add(dockingVo.getPositionCode());
            }
            customerCodeToPositionMap.put(customerVo.getCustomerCode(), positionCodeList);
        }
        List userList = this.userInfoVoService.findByPositionCodes(positionCodes);
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            Map<String, List<UserInfoVo>> positionToUserMap = userList.stream().collect(Collectors.groupingBy(UserInfoVo::getPositionCode));
            SysMessageDto msg = new SysMessageDto();
            msg.setCode(MessageTypeEnum.DELIVERY_DELAY.getDictCode());
            HashMap map = Maps.newHashMap();
            LinkedList userItems = Lists.newLinkedList();
            for (Order order : waitShippedOrders) {
                String relateCode = order.getRelateCode();
                List positionCodeList = (List)customerCodeToPositionMap.get(relateCode);
                if (CollectionUtils.isEmpty((Collection)positionCodeList)) continue;
                for (String positionCode : positionCodeList) {
                    List<UserInfoVo> userInfoVos = positionToUserMap.get(positionCode);
                    if (CollectionUtils.isEmpty(userInfoVos)) continue;
                    for (UserInfoVo userInfoVo : userInfoVos) {
                        SysMessageItemDto dto1 = new SysMessageItemDto();
                        dto1.setBusinessCode(userInfoVo.getUserName());
                        dto1.setBusinessType(MessageBusinessType.BACKGROUND.getDictCode());
                        dto1.setRelateCode(order.getId());
                        dto1.setRelateType(MessageRelateType.ORDER.getDictCode());
                        HashMap param1Map = Maps.newHashMap();
                        param1Map.put("orderCode", order.getOrderCode());
                        dto1.setParamsMap((Map)param1Map);
                        userItems.add(dto1);
                    }
                }
            }
            map.put(MessageHandlerEnum.DELIVERY_DELAY_USER.getDictCode(), userItems);
            msg.setMap((Map)map);
            this.sendMessageVoService.send(msg);
        }
    }

    private Date last10DaysStartTime() {
        LocalDateTime of = LocalDateTime.of(LocalDate.now().minus(10L, ChronoUnit.DAYS), LocalTime.MIN);
        return Date.from(of.atZone(ZoneId.systemDefault()).toInstant());
    }
}

