/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.notifier;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.order.local.entity.PurchaseHistory;
import com.biz.crm.dms.business.order.local.service.PurchaseHistoryService;
import com.biz.crm.mdm.business.product.sdk.dto.ProductEventDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductSingleEventDto;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.sdk.event.ProductEventListener;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductStatusEventListenerImpl
implements ProductEventListener {
    @Autowired
    private PurchaseHistoryService purchaseHistoryService;

    public void onUpdate(ProductEventDto productEventDto) {
        ProductVo vo = productEventDto.getNewest();
        PurchaseHistory purchaseHistory = new PurchaseHistory();
        purchaseHistory.setGoodsCode(vo.getProductCode());
        purchaseHistory.setGoodsName(vo.getProductName());
        purchaseHistory.setSpec(vo.getSpec());
        purchaseHistory.setUnite(vo.getSaleUnit());
        this.purchaseHistoryService.updateByProductCode(purchaseHistory);
        this.judgeUsable(vo);
    }

    public void onEnable(ProductSingleEventDto productSingleEventDto) {
        ProductVo vo = (ProductVo)JsonUtils.convert((Object)productSingleEventDto.getNewest(), ProductVo.class);
        this.judgeUsable(vo);
    }

    public void onDisable(ProductSingleEventDto productSingleEventDto) {
        ProductVo vo = (ProductVo)JsonUtils.convert((Object)productSingleEventDto.getNewest(), ProductVo.class);
        this.judgeUsable(vo);
    }

    public void onUpShelf(ProductSingleEventDto productSingleEventDto) {
        ProductVo vo = (ProductVo)JsonUtils.convert((Object)productSingleEventDto.getNewest(), ProductVo.class);
        this.judgeUsable(vo);
    }

    public void onDownShelf(ProductSingleEventDto productSingleEventDto) {
        ProductVo vo = (ProductVo)JsonUtils.convert((Object)productSingleEventDto.getNewest(), ProductVo.class);
        this.judgeUsable(vo);
    }

    private void judgeUsable(ProductVo vo) {
        String enableStatus = vo.getEnableStatus();
        String isShelf = vo.getIsShelf();
        String productCode = vo.getProductCode();
        if (EnableStatusEnum.ENABLE.getCode().equals(enableStatus) && IsShelfEnum.UP.getCode().equals(isShelf)) {
            this.purchaseHistoryService.updateUsableStatus(productCode, BooleanEnum.TRUE.getCapital());
        } else {
            this.purchaseHistoryService.updateUsableStatus(productCode, BooleanEnum.FALSE.getCapital());
        }
    }
}

