/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.notifier;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPayDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderDetail;
import com.biz.crm.dms.business.order.local.repository.OrderRepository;
import com.biz.crm.dms.business.order.local.service.assist.OrderAssist;
import com.biz.crm.dms.business.policy.sdk.service.SalePolicyRecordVoService;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalesOrderFlowCallBackImpl
implements CallBackListener {
    @Autowired(required=false)
    private OrderRepository orderRepository;
    @Autowired(required=false)
    private CostPoolVoService costPoolVoService;
    @Autowired(required=false)
    private OrderAssist orderAssist;
    @Autowired(required=false)
    private ProductStockVoService productStockVoService;
    @Autowired(required=false)
    private SalePolicyRecordVoService salePolicyRecordVoService;
    @Qualifier(value="DiscountApportionTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister discountApportionTallyItemRegister;
    @Qualifier(value="CreditTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister creditTallyItemRegister;
    @Qualifier(value="CapitalTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister capitalTallyItemRegister;

    @Transactional
    public void onCallBack(CallBackDto dto) {
        String formType = dto.getFormType();
        if (!OrderCategoryEnum.SALES_ORDER.getDictCode().equals(formType)) {
            return;
        }
        String formNo = dto.getFormNo();
        Order order = this.findByOrderCode(formNo);
        if (Objects.isNull((Object)order)) {
            return;
        }
        String orderStatus = order.getOrderStatus();
        String awaitApprove = OrderStatusEnum.AWAIT_APPROVE.getDictCode();
        boolean equals = awaitApprove.equals(orderStatus);
        Validate.isTrue((boolean)equals, (String)"\u6b64\u8ba2\u5355\u975e\u5ba1\u6279\u4e2d\u72b6\u6001\uff0c\u65e0\u6cd5\u63a5\u53d7\u5de5\u4f5c\u6d41\u7684\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        Integer processState = dto.getProcessState();
        orderStatus = this.getOrderStatus(processState);
        this.orderRepository.updateOrderStatusById(orderStatus, order.getId());
        boolean isWaitShipped = OrderStatusEnum.WAIT_SHIPPED.getDictCode().equals(orderStatus);
        if (isWaitShipped) {
            this.payOrder(order);
            return;
        }
        this.releaseOrder(order);
        this.releaseSalePolicy(order);
        this.returnStock(order);
    }

    private void returnStock(Order order) {
        WarehouseVo warehouse = this.orderAssist.findWarehouseVo(order);
        Validate.notNull((Object)warehouse, (String)"\u8ba2\u5355\u5360\u7528\u5e93\u5b58\u7684\u65f6\u5019\uff0c\u6ca1\u6709\u627e\u5230\u4ed3\u5e93\u4fe1\u606f", (Object[])new Object[0]);
        List<ProductStockOperationDto> list = this.orderAssist.getProductStockOperationDtos(order, warehouse);
        this.productStockVoService.thawBatch(list);
    }

    private Order findByOrderCode(String orderCode) {
        List<Order> orderList = this.orderRepository.findDetailByOrderCodes(Lists.newArrayList((Object[])new String[]{orderCode}));
        Validate.isTrue((!CollectionUtils.isEmpty(orderList) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((orderList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u51fa\u4e86\u591a\u6761\u6570\u636e\uff0c\u8fd9\u5e94\u8be5\u662f\u4e00\u4e2a\u6570\u636e\u9519\u8bef\u3002", (Object[])new Object[0]);
        return orderList.get(0);
    }

    private void releaseSalePolicy(Order order) {
        boolean isMaterial = order.getOrderCategory().equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode());
        if (isMaterial) {
            return;
        }
        this.salePolicyRecordVoService.deleteByBillCode(order.getOrderCode(), order.getTenantCode(), order.getRelateCode());
    }

    private void payOrder(Order order) {
        this.releaseOrder(order);
        this.useAmount(order);
    }

    private void useAmount(Order order) {
        List<CostPoolReplenishmentDto> replenishmentDto;
        CostPoolDiscountDto discountDto;
        CreditPayDto creditPayDto;
        boolean isFree = OrderTypeEnum.FREE.getDictCode().equals(order.getOrderType());
        boolean isMaterial = order.getOrderCategory().equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode());
        if (isFree || isMaterial) {
            return;
        }
        JSONArray array = new JSONArray();
        CostPoolCapitalDto costPoolCapitalDto = this.getCapitalDto(order, CapitalAdjustTypeEnum.ORDER_USE);
        if (Objects.nonNull(costPoolCapitalDto)) {
            array.add((Object)costPoolCapitalDto);
        }
        if (Objects.nonNull(creditPayDto = this.getCreditPayDto(order, CashAdjustOperateEnum.ORDER, CashAdjustTypeEnum.CREDIT_REDUCE))) {
            array.add((Object)creditPayDto);
        }
        if (Objects.nonNull(discountDto = this.getDiscountDto(order, PoolOperationTypeEnum.ORDER_USE))) {
            array.add((Object)discountDto);
        }
        if (!CollectionUtils.isEmpty(replenishmentDto = this.getReplenishmentDto(order, com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum.ORDER_USE))) {
            array.addAll(replenishmentDto);
        }
        this.costPoolVoService.handleAdjust(array);
    }

    private void releaseOrder(Order order) {
        List<CostPoolReplenishmentDto> replenishmentDto;
        CostPoolDiscountDto discountDto;
        CreditPayDto creditPayDto;
        boolean isFree = OrderTypeEnum.FREE.getDictCode().equals(order.getOrderType());
        boolean isMaterial = order.getOrderCategory().equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode());
        if (isFree || isMaterial) {
            return;
        }
        JSONArray array = new JSONArray();
        CostPoolCapitalDto costPoolCapitalDto = this.getCapitalDto(order, CapitalAdjustTypeEnum.OCCUPY_RELEASE);
        if (Objects.nonNull(costPoolCapitalDto)) {
            array.add((Object)costPoolCapitalDto);
        }
        if (Objects.nonNull(creditPayDto = this.getCreditPayDto(order, CashAdjustOperateEnum.OCCUPY_RELEASE, CashAdjustTypeEnum.OCCUPY_RELEASE))) {
            array.add((Object)creditPayDto);
        }
        if (Objects.nonNull(discountDto = this.getDiscountDto(order, PoolOperationTypeEnum.OCCUPY_RELEASE))) {
            array.add((Object)discountDto);
        }
        if (!CollectionUtils.isEmpty(replenishmentDto = this.getReplenishmentDto(order, com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum.OCCUPY_RELEASE))) {
            array.addAll(replenishmentDto);
        }
        this.costPoolVoService.handleAdjust(array);
    }

    private List<CostPoolReplenishmentDto> getReplenishmentDto(Order order, com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum operationTypeEnum) {
        List<OrderDetail> orderDetails = order.getOrderDetails();
        if (CollectionUtils.isEmpty(orderDetails)) {
            return null;
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)orderDetails.size());
        for (OrderDetail orderDetail : orderDetails) {
            BigDecimal salesAmount = orderDetail.getSalesAmount();
            String itemType = orderDetail.getItemType();
            if (!itemType.equals(ItemTypeEnum.COMPENSATED_GOODS.getDictCode())) continue;
            CostPoolReplenishmentDto dto = OrderAssist.getCostPoolReplenishmentDto(order, orderDetail, salesAmount, operationTypeEnum);
            list.add(dto);
        }
        return list;
    }

    private CostPoolDiscountDto getDiscountDto(Order order, PoolOperationTypeEnum operationTypeEnum) {
        BigDecimal itemAmount = OrderAssist.getTallyItemAmount(order, this.discountApportionTallyItemRegister);
        if (itemAmount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return OrderAssist.getCostPoolDiscountDto(order, itemAmount, operationTypeEnum);
    }

    private CreditPayDto getCreditPayDto(Order order, CashAdjustOperateEnum operateEnum, CashAdjustTypeEnum adjustTypeEnum) {
        BigDecimal itemAmount = OrderAssist.getTallyItemAmount(order, this.creditTallyItemRegister);
        if (itemAmount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return OrderAssist.getCreditPayDto(order, itemAmount, operateEnum, adjustTypeEnum);
    }

    private CostPoolCapitalDto getCapitalDto(Order order, CapitalAdjustTypeEnum capitalAdjustTypeEnum) {
        BigDecimal itemAmount = OrderAssist.getTallyItemAmount(order, this.capitalTallyItemRegister);
        if (itemAmount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return OrderAssist.getCostPoolCapitalDto(order, itemAmount, capitalAdjustTypeEnum);
    }

    private String getOrderStatus(Integer processState) {
        HashMap<String, String> map = new HashMap<String, String>(ActApproveStatusEnum.values().length);
        map.put(ActApproveStatusEnum.APPROVED.getCode(), OrderStatusEnum.WAIT_SHIPPED.getDictCode());
        map.put(ActApproveStatusEnum.REJECTED.getCode(), OrderStatusEnum.REJECTED.getDictCode());
        map.put(ActApproveStatusEnum.INTERRUPT.getCode(), OrderStatusEnum.CANCELED.getDictCode());
        map.put(ActApproveStatusEnum.CLOSED.getCode(), OrderStatusEnum.CLOSE.getDictCode());
        return (String)map.get(processState.toString());
    }
}

