/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.mapper.OrderMapper;
import com.biz.crm.dms.business.order.sdk.dto.CustomerOrderPageDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderPaginationDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrderRepository
extends ServiceImpl<OrderMapper, Order> {
    @Autowired(required=false)
    private OrderMapper orderMapper;

    public Page<Order> findByConditions(Pageable pageable, OrderPaginationDto orderPaginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Order> pageList = this.orderMapper.findByConditions((Page<Order>)page, orderPaginationDto);
        return pageList;
    }

    public Order findByOrderCode(String orderCode) {
        return (Order)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Order::getAppCode, (Object)TenantUtils.getAppCode())).eq(Order::getOrderCode, (Object)orderCode)).one());
    }

    public List<Order> findDetailByOrderCodes(List<String> orderCodes) {
        if (CollectionUtils.isEmpty(orderCodes)) {
            return null;
        }
        return ((OrderMapper)this.baseMapper).findDetailByOrderCodes(orderCodes, TenantUtils.getAppCode());
    }

    public void updateOrderStatusById(String orderStatus, String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Order::getOrderStatus, (Object)orderStatus)).eq(UuidEntity::getId, (Object)id)).update();
    }

    public void updateOrderStatusAndIsShowById(String orderStatus, String id, Boolean isShow) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Order::getOrderStatus, (Object)orderStatus)).set(Order::getIsShow, (Object)isShow)).eq(UuidEntity::getId, (Object)id)).update();
    }

    public void updateOrderStatusAndProcessNumberById(String orderStatus, String processNumber, String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Order::getOrderStatus, (Object)orderStatus)).set(WorkflowFlagOpEntity::getProcessNumber, (Object)processNumber)).eq(UuidEntity::getId, (Object)id)).update();
    }

    public void updateOrderStatusAndDeliveryQuantityById(String orderStatus, BigDecimal deliveryQuantity, String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Order::getOrderStatus, (Object)orderStatus)).set(Order::getDeliveryQuantity, (Object)deliveryQuantity)).eq(UuidEntity::getId, (Object)id)).update();
    }

    public Order findDetailById(String id) {
        return ((OrderMapper)this.baseMapper).findDetailById(id);
    }

    public List<Order> findByRelateCodeAndOrderStatusIn(String relateCode, List<String> orderStatusList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Order::getRelateCode, (Object)relateCode)).eq(Order::getAppCode, (Object)TenantUtils.getAppCode())).in(Order::getOrderStatus, orderStatusList)).list();
    }

    public Page<Order> findByCustomerOrderPageDto(Pageable pageable, CustomerOrderPageDto customerOrderPageDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Order> pageList = this.orderMapper.findByCustomerOrderPageDto((Page<Order>)page, customerOrderPageDto);
        return pageList;
    }

    public List<Order> findByOrderStatusAndCreateTimeLe(OrderStatusEnum orderStatusEnum, Date date) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Order::getAppCode, (Object)TenantUtils.getAppCode())).eq(Order::getOrderStatus, (Object)orderStatusEnum.getDictCode())).le(UuidOpEntity::getCreateTime, (Object)date)).list();
        return list;
    }
}

