/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.AppFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.order.local.entity.PurchaseHistory;
import com.biz.crm.dms.business.order.local.mapper.PurchaseHistoryMapper;
import com.biz.crm.dms.business.order.sdk.dto.PurchaseHistoryPageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class PurchaseHistoryRepository
extends ServiceImpl<PurchaseHistoryMapper, PurchaseHistory> {
    @Autowired(required=false)
    private PurchaseHistoryMapper purchaseHistoryMapper;

    public Page<PurchaseHistory> findByConditions(Pageable pageable, PurchaseHistoryPageDto purchaseHistory) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<PurchaseHistory> pageList = this.purchaseHistoryMapper.findByConditions((Page<PurchaseHistory>)page, purchaseHistory);
        return pageList;
    }

    public void deleteByIdIn(List<String> idList) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, idList);
    }

    public List<PurchaseHistory> findByGoodsCodeInAndRelateCode(List<String> goodsCodes, String relateCode) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PurchaseHistory::getRelateCode, (Object)relateCode)).eq(AppFlagOpEntity::getAppCode, (Object)TenantUtils.getAppCode())).in(PurchaseHistory::getGoodsCode, goodsCodes)).list();
        return list;
    }

    public void updateTimesIncrementByIdIn(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().setSql("times = times + 1")).in(UuidEntity::getId, ids)).update();
    }

    public List<PurchaseHistory> findByGoodsCode(String code) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(PurchaseHistory::getGoodsCode, (Object)code)).list();
    }

    public void updateUsableStatus(String goodsCode, String isUsable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(PurchaseHistory::getGoodsCode, (Object)goodsCode)).set(PurchaseHistory::getIsUsable, (Object)isUsable)).update();
    }

    public void updateByProductCode(PurchaseHistory purchaseHistory) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(PurchaseHistory::getGoodsCode, (Object)purchaseHistory.getGoodsCode())).set(PurchaseHistory::getGoodsName, (Object)purchaseHistory.getGoodsName())).set(PurchaseHistory::getUnite, (Object)purchaseHistory.getUnite())).set(PurchaseHistory::getSpec, (Object)purchaseHistory.getSpec())).update();
    }
}

