/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.assist;

import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPayDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditPoolTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolPayTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolUseTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.common.sdk.model.TallyItemRegisterModel;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderDetail;
import com.biz.crm.dms.business.order.local.entity.OrderPay;
import com.biz.crm.dms.business.order.sdk.dto.OrderDetailPreviewDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderPreviewDto;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailPreviewVo;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperationType;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import com.biz.crm.mdm.business.warehouse.sdk.service.WarehouseVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrderAssist {
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;
    @Autowired(required=false)
    private MaterialVoService materialVoService;
    @Autowired(required=false)
    private WarehouseVoService warehouseVoService;

    public static void filterOrderDetails(List<OrderDetailPreviewVo> inputOrderDetails, Map<String, OrderDetailPreviewVo> unionMap) {
        if (!CollectionUtils.isEmpty(inputOrderDetails)) {
            for (OrderDetailPreviewVo inputOrderDetail : inputOrderDetails) {
                String itemCode;
                String orderDetailCode = inputOrderDetail.getOrderDetailCode();
                orderDetailCode = StringUtils.isBlank((CharSequence)orderDetailCode) ? "" : orderDetailCode;
                String goodsCode = inputOrderDetail.getGoodsCode();
                String itemType = inputOrderDetail.getItemType();
                String string = itemCode = StringUtils.isBlank((CharSequence)inputOrderDetail.getItemCode()) ? "" : inputOrderDetail.getItemCode();
                String key = StringUtils.join((Object[])new String[]{itemType, "-", goodsCode, "-", orderDetailCode, "-", itemCode});
                if (unionMap.containsKey(key)) continue;
                unionMap.put(key, inputOrderDetail);
            }
        }
    }

    public void filterAndInitializeData(OrderPreviewDto order) {
        List orderDetailsList = order.getOrderDetails();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)orderDetailsList) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u8d27\u7269\u4f20\u5165", (Object[])new Object[0]);
        List nonComplimentaryGoods = orderDetailsList.stream().filter(orderDetail -> {
            Validate.notBlank((CharSequence)orderDetail.getItemType(), (String)"\u884c\u9879\u76ee\u7c7b\u578b\u5fc5\u4f20\uff01", (Object[])new Object[0]);
            return !orderDetail.getItemType().equals(ItemTypeEnum.COMPLIMENTARY_GOODS.getDictCode());
        }).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(nonComplimentaryGoods) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u975e\u8d60\u54c1\u8d27\u7269\u4f20\u5165", (Object[])new Object[0]);
        order.setOrderDetails(nonComplimentaryGoods);
        for (OrderDetailPreviewDto nonComplimentaryGood : nonComplimentaryGoods) {
            Boolean isAutoHit = nonComplimentaryGood.getIsAutoHit();
            if (!isAutoHit.booleanValue()) {
                nonComplimentaryGood.setOrderDetailPays((List)Lists.newArrayList());
                continue;
            }
            List orderDetailPays = nonComplimentaryGood.getOrderDetailPays();
            if (!CollectionUtils.isEmpty((Collection)orderDetailPays)) continue;
            nonComplimentaryGood.setOrderDetailPays(null);
        }
        Set<String> productCodeSet = orderDetailsList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getGoodsCode())).map(OrderDetailPreviewDto::getGoodsCode).collect(Collectors.toSet());
        Map<String, BigDecimal> priceMap = this.getPriceMap(order, productCodeSet);
        for (OrderDetailPreviewDto previewDto : orderDetailsList) {
            BigDecimal price = priceMap.get(previewDto.getGoodsCode());
            Validate.notNull((Object)price, (String)StringUtils.join((Object[])new String[]{"\u6ca1\u6709\u67e5\u8be2\u5230\u5546\u54c1\u4ef7\u683c:", previewDto.getGoodsCode()}), (Object[])new Object[0]);
            previewDto.setPresetUnitPrice(price);
            BigDecimal quantity = previewDto.getQuantity();
            Validate.notNull((Object)quantity, (String)StringUtils.join((Object[])new String[]{"\u8d2d\u4e70\u6570\u91cf\u5fc5\u987b\u4f20:", previewDto.getGoodsCode()}), (Object[])new Object[0]);
            previewDto.setSalesAmount(quantity.multiply(price));
        }
    }

    private Map<String, BigDecimal> getPriceMap(OrderPreviewDto order, Set<String> goodsCodeSet) {
        HashMap<String, BigDecimal> priceMap = new HashMap<String, BigDecimal>(goodsCodeSet.size());
        String orderCategory = order.getOrderCategory();
        if (orderCategory.equals(OrderCategoryEnum.SALES_ORDER.getDictCode())) {
            FindPriceDto findPriceDto = new FindPriceDto();
            findPriceDto.setUserType(FindPriceUserTypeEnum.CUSTOMER.getDictCode());
            findPriceDto.setUserCode(order.getRelateCode());
            findPriceDto.setProductCodeSet(goodsCodeSet);
            Map mapPriceModelVo = this.priceModelVoService.findPrice(findPriceDto);
            Validate.notNull((Object)mapPriceModelVo, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u4ef7\u683c\uff1a%s", (Object[])new Object[]{findPriceDto.toString()});
            for (Map.Entry entry : mapPriceModelVo.entrySet()) {
                priceMap.put((String)entry.getKey(), ((PriceModelVo)entry.getValue()).getPrice());
            }
        } else if (orderCategory.equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode())) {
            List materialList = this.materialVoService.findDetailByMaterialCodes(goodsCodeSet);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)materialList) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7269\u6599\u4ef7\u683c\uff01", (Object[])new Object[0]);
            for (MaterialVo materialVo : materialList) {
                String costPrice = materialVo.getCostPrice();
                if (!StringUtils.isNotBlank((CharSequence)costPrice)) continue;
                priceMap.put(materialVo.getMaterialCode(), new BigDecimal(costPrice));
            }
        } else {
            throw new IllegalArgumentException("\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u8be5\u8ba2\u5355\u7c7b\u522b");
        }
        return priceMap;
    }

    public static List<OrderDetailPreviewVo> unionOrderDetails(List<OrderDetailPreviewVo> inputOrderDetails, List<OrderDetailPreviewVo> orderDetails) {
        if (CollectionUtils.isEmpty(inputOrderDetails)) {
            return orderDetails;
        }
        if (CollectionUtils.isEmpty(orderDetails)) {
            return inputOrderDetails;
        }
        HashMap<String, OrderDetailPreviewVo> unionMap = new HashMap<String, OrderDetailPreviewVo>(inputOrderDetails.size() + orderDetails.size());
        OrderAssist.filterOrderDetails(orderDetails, unionMap);
        OrderAssist.filterOrderDetails(inputOrderDetails, unionMap);
        Collection values = unionMap.values();
        return Lists.newArrayList(values);
    }

    public static BigDecimal getTallyItemAmount(Order order, TallyItemRegister creditTallyItemRegister) {
        List<OrderPay> orderPays = order.getOrderPays();
        BigDecimal itemAmount = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(orderPays)) {
            return itemAmount;
        }
        for (OrderPay orderPay : orderPays) {
            TallyItemRegisterModel tallyItemRegisterModel;
            String itemKey1;
            String itemKey = orderPay.getItemKey();
            if (StringUtils.isBlank((CharSequence)itemKey) || !itemKey.equals(itemKey1 = (tallyItemRegisterModel = creditTallyItemRegister.findTallyItemRegisterModel()).getItemKey())) continue;
            itemAmount = orderPay.getItemAmount();
            break;
        }
        return itemAmount;
    }

    public WarehouseVo findWarehouseVo(Order order) {
        WarehouseVo warehouse = null;
        if (order.getOrderCategory().equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode())) {
            String warehouseCode = order.getWarehouseCode();
            warehouse = this.warehouseVoService.findDetailsByCode(warehouseCode);
        } else {
            warehouse = this.warehouseVoService.findDetailsByCityCode(order.getCityCode());
            if (warehouse == null) {
                warehouse = this.warehouseVoService.findDetailsByWarehouseDefault(Boolean.valueOf(true));
            }
        }
        return warehouse;
    }

    public List<ProductStockOperationDto> getProductStockOperationDtos(Order order, WarehouseVo warehouse) {
        List<OrderDetail> orderDetails = order.getOrderDetails();
        Validate.isTrue((!CollectionUtils.isEmpty(orderDetails) ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5360\u7528\u5e93\u5b58\u7684\u65f6\u5019\uff0c\u6ca1\u6709\u8d27\u7269\u4fe1\u606f", (Object[])new Object[0]);
        ArrayList list = Lists.newArrayListWithCapacity((int)orderDetails.size());
        for (OrderDetail orderDetail : orderDetails) {
            ProductStockOperationDto productStockOperationDto = new ProductStockOperationDto();
            productStockOperationDto.setWarehouseCode(warehouse.getWarehouseCode());
            productStockOperationDto.setWarehouseName(warehouse.getWarehouseName());
            productStockOperationDto.setProductCode(orderDetail.getGoodsCode());
            productStockOperationDto.setProductName(orderDetail.getGoodsName());
            productStockOperationDto.setProductStockOperationType(ProductStockOperationType.SALE_DELIVER.getDictCode());
            productStockOperationDto.setCustomerCode(order.getRelateCode());
            productStockOperationDto.setCustomerName(order.getRelateName());
            productStockOperationDto.setOriginalOrderCode(order.getOriginalOrderCode());
            productStockOperationDto.setOrderType(order.getOrderType());
            productStockOperationDto.setOrderCode(order.getOrderCode());
            productStockOperationDto.setOrderItemCode(orderDetail.getOrderDetailCode());
            productStockOperationDto.setQuantity(orderDetail.getQuantity());
            list.add(productStockOperationDto);
        }
        return list;
    }

    public static CostPoolCapitalDto getCostPoolCapitalDto(Order order, BigDecimal itemAmount, CapitalAdjustTypeEnum capitalAdjustTypeEnum) {
        CostPoolCapitalDto dto = new CostPoolCapitalDto();
        dto.setPoolType(PoolTypeEnum.CAPITAL.getKey());
        dto.setCustomerCode(order.getRelateCode());
        dto.setFromCode(order.getOrderCode());
        dto.setFromDesc(capitalAdjustTypeEnum.getValue());
        dto.setAmount(itemAmount);
        dto.setAdjustMoney(itemAmount);
        dto.setAdjustType(capitalAdjustTypeEnum.getKey());
        dto.setAdjustTypeName(capitalAdjustTypeEnum.getValue());
        dto.setBillNo(order.getOrderCode());
        dto.setBillType(order.getOrderType());
        return dto;
    }

    public static CreditPayDto getCreditPayDto(Order order, BigDecimal itemAmount, CashAdjustOperateEnum cashAdjustOperateEnum, CashAdjustTypeEnum cashAdjustTypeEnum) {
        CreditPayDto dto = new CreditPayDto();
        dto.setPoolType(CreditPoolTypeEnum.CREDIT.getKey());
        dto.setCustomerCode(order.getRelateCode());
        dto.setFromCode(order.getOrderCode());
        dto.setFromDesc(cashAdjustOperateEnum.getValue());
        dto.setAmount(itemAmount);
        dto.setAdjustTypeCode(cashAdjustTypeEnum.getDictCode());
        dto.setAdjustOperateCode(cashAdjustOperateEnum.getDictCode());
        return dto;
    }

    public static CostPoolDiscountDto getCostPoolDiscountDto(Order order, BigDecimal itemAmount, PoolOperationTypeEnum poolOperationTypeEnum) {
        CostPoolDiscountDto dto = new CostPoolDiscountDto();
        dto.setPoolType(com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getKey());
        dto.setCustomerCode(order.getRelateCode());
        dto.setFromCode(order.getOrderCode());
        dto.setFromDesc(poolOperationTypeEnum.getValue());
        dto.setAmount(itemAmount);
        dto.setPoolGroup(PoolGroupEnum.DEFAULT.getDictCode());
        dto.setPayType(PoolPayTypeEnum.DISCOUNT.getDictCode());
        dto.setUseType(com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolUseTypeEnum.DEFAULT.getDictCode());
        dto.setCustomerName(order.getRelateName());
        dto.setOperationType(poolOperationTypeEnum.getDictCode());
        return dto;
    }

    public static CostPoolReplenishmentDto getCostPoolReplenishmentDto(Order order, OrderDetail orderDetail, BigDecimal salesAmount, com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum poolOperationTypeEnum) {
        CostPoolReplenishmentDto dto = new CostPoolReplenishmentDto();
        dto.setPoolType(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum.Replenishment.getKey());
        dto.setCustomerCode(order.getRelateCode());
        dto.setFromCode(order.getOrderCode());
        dto.setFromDesc(poolOperationTypeEnum.getValue());
        dto.setAmount(salesAmount);
        dto.setPoolGroup(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolGroupEnum.DEFAULT.getDictCode());
        dto.setPoolCode(orderDetail.getItemCode());
        dto.setPayType(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolPayTypeEnum.Replenishment.getDictCode());
        dto.setUseType(PoolUseTypeEnum.DEFAULT.getDictCode());
        dto.setCustomerName(order.getRelateName());
        dto.setOperationType(poolOperationTypeEnum.getDictCode());
        return dto;
    }

    public static List<FileVo> getFileVos(List<ProductMediaVo> productVo) {
        List<ProductMediaVo> productMediaVos = productVo;
        if (CollectionUtils.isEmpty(productMediaVos)) {
            return null;
        }
        ArrayList<FileVo> pictureFileList = new ArrayList<FileVo>(productMediaVos.size());
        for (ProductMediaVo item : productMediaVos) {
            FileVo fileVo = new FileVo();
            fileVo.setUrl(item.getUrlAddress());
            fileVo.setFileName(item.getFileName());
            fileVo.setObjectName(item.getObjectName());
            pictureFileList.add(fileVo);
        }
        return pictureFileList;
    }
}

