/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.order.local.entity.HistoryViewQueryConfig;
import com.biz.crm.dms.business.order.local.repository.HistoryViewQueryConfigRepository;
import com.biz.crm.dms.business.order.local.service.HistoryViewQueryConfigService;
import com.biz.crm.dms.business.order.sdk.constant.PurchaseHistoryConstant;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="HistoryViewQueryConfigService")
public class HistoryViewQueryConfigServiceImpl
implements HistoryViewQueryConfigService {
    @Autowired(required=false)
    private HistoryViewQueryConfigRepository historyViewQueryConfigRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public Page<HistoryViewQueryConfig> findByConditions(Pageable pageable, HistoryViewQueryConfig historyViewQueryConfig) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)historyViewQueryConfig)) {
            historyViewQueryConfig = new HistoryViewQueryConfig();
        }
        historyViewQueryConfig.setAppCode(TenantUtils.getAppCode());
        return this.historyViewQueryConfigRepository.findByConditions(pageable, historyViewQueryConfig);
    }

    @Override
    public HistoryViewQueryConfig findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (HistoryViewQueryConfig)((Object)this.historyViewQueryConfigRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public HistoryViewQueryConfig create(HistoryViewQueryConfig historyViewQueryConfig) {
        this.createValidate(historyViewQueryConfig);
        historyViewQueryConfig.setAppCode(TenantUtils.getAppCode());
        historyViewQueryConfig.setTenantCode(TenantUtils.getTenantCode());
        this.historyViewQueryConfigRepository.saveOrUpdate((Object)historyViewQueryConfig);
        return historyViewQueryConfig;
    }

    @Override
    @Transactional
    public HistoryViewQueryConfig update(HistoryViewQueryConfig historyViewQueryConfig) {
        this.updateValidate(historyViewQueryConfig);
        LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        HistoryViewQueryConfig config = this.historyViewQueryConfigRepository.findByRelateCode(loginUserDetails.getCustomerCode());
        historyViewQueryConfig.setTenantCode(TenantUtils.getTenantCode());
        historyViewQueryConfig.setAppCode(TenantUtils.getAppCode());
        if (Objects.nonNull((Object)config)) {
            historyViewQueryConfig.setId(config.getId());
        }
        historyViewQueryConfig.setRelateCode(loginUserDetails.getCustomerCode());
        this.historyViewQueryConfigRepository.saveOrUpdate((Object)historyViewQueryConfig);
        return historyViewQueryConfig;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.historyViewQueryConfigRepository.removeByIds(idList);
    }

    @Override
    public HistoryViewQueryConfig findByCurrentCustomerCode() {
        LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        HistoryViewQueryConfig config = this.historyViewQueryConfigRepository.findByRelateCode(loginUserDetails.getCustomerCode());
        if (Objects.isNull((Object)config)) {
            config = new HistoryViewQueryConfig();
            config.setTimes(PurchaseHistoryConstant.defaultTimes);
        }
        return config;
    }

    private void createValidate(HistoryViewQueryConfig historyViewQueryConfig) {
        Validate.notNull((Object)((Object)historyViewQueryConfig), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        historyViewQueryConfig.setId(null);
        Validate.notBlank((CharSequence)historyViewQueryConfig.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)historyViewQueryConfig.getRelateCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u8054\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(HistoryViewQueryConfig historyViewQueryConfig) {
        Validate.notNull((Object)((Object)historyViewQueryConfig), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)historyViewQueryConfig.getTimes(), (String)"\u4fee\u6539\u65f6\uff0c\u8d2d\u4e70\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Integer times = historyViewQueryConfig.getTimes();
        int compare = times.compareTo(0);
        Validate.isTrue((compare > 0 ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u8d2d\u4e70\u6b21\u6570\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0", (Object[])new Object[0]);
    }
}

