/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPayDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderDetail;
import com.biz.crm.dms.business.order.local.repository.OrderRepository;
import com.biz.crm.dms.business.order.local.service.assist.OrderAssist;
import com.biz.crm.dms.business.order.sdk.dto.OrderEventDto;
import com.biz.crm.dms.business.order.sdk.event.OrderCloseListener;
import com.biz.crm.dms.business.order.sdk.event.OrderLogEventListener;
import com.biz.crm.dms.business.order.sdk.service.OrderCloseService;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.dms.business.policy.sdk.service.SalePolicyRecordVoService;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrderCloseServiceImpl
implements OrderCloseService {
    @Autowired(required=false)
    private OrderRepository orderRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<OrderCloseListener> orderCloseListeners;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SalePolicyRecordVoService salePolicyRecordVoService;
    @Autowired(required=false)
    private OrderAssist orderAssist;
    @Autowired(required=false)
    private ProductStockVoService productStockVoService;
    @Autowired(required=false)
    private CostPoolVoService costPoolVoService;
    @Qualifier(value="CapitalTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister capitalTallyItemRegister;
    @Qualifier(value="CreditTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister creditTallyItemRegister;
    @Qualifier(value="DiscountApportionTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister discountApportionTallyItemRegister;

    @Transactional
    public void handleClose(String orderCode) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderCode), (String)"\u8ba2\u5355\u7f16\u7801\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Order order = this.findByOrderCode(orderCode);
        this.isCloseable(order);
        this.closeWaitShipped(order);
        this.closePartShipped(order);
        String dictCode = OrderStatusEnum.CLOSE.getDictCode();
        this.orderRepository.updateOrderStatusById(dictCode, order.getId());
        this.recordOperationLog(order, dictCode);
    }

    private void recordOperationLog(Order order, String dictCode) {
        LoginDetails loginUser = this.loginUserService.getLoginUser();
        OrderEventDto orderEventDto = new OrderEventDto();
        OrderVo original = new OrderVo();
        original.setId(order.getId());
        original.setOrderStatus(order.getOrderStatus());
        original.setModifyAccount(order.getModifyAccount());
        original.setOrderCode(order.getOrderCode());
        original.setRelateCode(order.getRelateCode());
        original.setCreateAccount(order.getCreateAccount());
        orderEventDto.setOriginal(original);
        OrderVo newest = new OrderVo();
        newest.setId(order.getId());
        newest.setOrderStatus(dictCode);
        newest.setModifyAccount(loginUser.getAccount());
        newest.setOrderCode(order.getOrderCode());
        newest.setRelateCode(order.getRelateCode());
        newest.setCreateAccount(order.getCreateAccount());
        orderEventDto.setNewest(newest);
        SerializableBiConsumer & Serializable onClose = OrderLogEventListener::onClose;
        this.nebulaNetEventClient.publish((NebulaEventDto)orderEventDto, OrderLogEventListener.class, (SerializableBiConsumer)onClose);
    }

    public void handleFlowClose(String orderCode) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderCode), (String)"\u8ba2\u5355\u7f16\u7801\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Order order = this.findByOrderCode(orderCode);
        boolean isMaterial = order.getOrderCategory().equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode());
        if (!isMaterial) {
            this.returnFee(order);
            this.salePolicyRecordVoService.deleteByBillCode(order.getOrderCode(), order.getTenantCode(), order.getRelateCode());
        }
        this.returnStock(order);
    }

    private void isCloseable(Order order) {
        String orderStatus = order.getOrderStatus();
        OrderStatusEnum orderStatusEnum = OrderStatusEnum.findByCode((String)orderStatus);
        Validate.notNull((Object)orderStatusEnum, (String)"\u975e\u6cd5\u72b6\u6001\u7684\u8ba2\u5355", (Object[])new Object[0]);
        boolean isWaitShipped = OrderStatusEnum.WAIT_SHIPPED.getDictCode().equals(orderStatus);
        boolean isPartShipped = OrderStatusEnum.PART_SHIPPED.getDictCode().equals(orderStatus);
        Validate.isTrue((isWaitShipped || isPartShipped ? 1 : 0) != 0, (String)"\u72b6\u6001\uff1a%s \u7684\u8ba2\u5355\u65e0\u6cd5\u5173\u95ed", (Object[])new Object[]{orderStatusEnum.getValue()});
    }

    private void closeWaitShipped(Order order) {
        String orderStatus = order.getOrderStatus();
        boolean isWaitShipped = OrderStatusEnum.WAIT_SHIPPED.getDictCode().equals(orderStatus);
        if (!isWaitShipped) {
            return;
        }
        this.returnFee(order);
        this.returnStock(order);
        this.salePolicyRecordVoService.deleteByBillCode(order.getOrderCode(), order.getTenantCode(), order.getRelateCode());
    }

    private void closePartShipped(Order order) {
        String orderStatus = order.getOrderStatus();
        boolean isPartShipped = OrderStatusEnum.PART_SHIPPED.getDictCode().equals(orderStatus);
        if (!isPartShipped) {
            return;
        }
        Validate.isTrue((!CollectionUtils.isEmpty(this.orderCloseListeners) ? 1 : 0) != 0, (String)"\u90e8\u5206\u5173\u95ed\u8ba2\u5355\u65f6\uff0c\u6ca1\u6709\u8ba2\u5355\u5173\u95ed\u76d1\u542c\u8005\u662f\u4e0d\u53ef\u80fd\u7684", (Object[])new Object[0]);
        OrderCloseListener orderCloseListener = this.orderCloseListeners.get(0);
        OrderVo orderVoCopy = (OrderVo)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderVo.class, HashSet.class, LinkedList.class, new String[0]);
        OrderVo orderVo = orderCloseListener.onReturn(orderVoCopy);
        Order returnOrder = (Order)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)orderVo, Order.class, HashSet.class, LinkedList.class, new String[0]));
        this.returnFee(returnOrder);
        this.returnStock(returnOrder);
    }

    private void returnStock(Order order) {
        WarehouseVo warehouse = this.orderAssist.findWarehouseVo(order);
        Validate.notNull((Object)warehouse, (String)"\u8ba2\u5355\u5360\u7528\u5e93\u5b58\u7684\u65f6\u5019\uff0c\u6ca1\u6709\u627e\u5230\u4ed3\u5e93\u4fe1\u606f", (Object[])new Object[0]);
        List<ProductStockOperationDto> list = this.orderAssist.getProductStockOperationDtos(order, warehouse);
        this.productStockVoService.thawBatch(list);
    }

    private void returnFee(Order order) {
        List<CostPoolReplenishmentDto> replenishmentDto;
        CostPoolDiscountDto discountDto;
        CreditPayDto creditPayDto;
        JSONArray array = new JSONArray();
        CostPoolCapitalDto costPoolCapitalDto = this.getCapitalDto(order);
        if (Objects.nonNull(costPoolCapitalDto)) {
            array.add((Object)costPoolCapitalDto);
        }
        if (Objects.nonNull(creditPayDto = this.getCreditPayDto(order))) {
            List costPoolVos = this.costPoolVoService.handleRequestCostPoolVos((CostPoolDto)creditPayDto);
            CostPoolVo costPoolVo = (CostPoolVo)costPoolVos.get(0);
            BigDecimal hasUseAmount = costPoolVo.getHasUseAmount();
            int compare = hasUseAmount.compareTo(creditPayDto.getAmount());
            if (compare >= 0) {
                array.add((Object)creditPayDto);
            } else {
                CostPoolCapitalDto creditToCapitalDto = OrderAssist.getCostPoolCapitalDto(order, creditPayDto.getAmount(), CapitalAdjustTypeEnum.ORDER_CLOSE);
                array.add((Object)creditToCapitalDto);
            }
        }
        if (Objects.nonNull(discountDto = this.getDiscountDto(order))) {
            array.add((Object)discountDto);
        }
        if (!CollectionUtils.isEmpty(replenishmentDto = this.getReplenishmentDto(order))) {
            array.addAll(replenishmentDto);
        }
        this.costPoolVoService.handleAdjust(array);
    }

    private Order findByOrderCode(String orderCode) {
        List<Order> orderList = this.orderRepository.findDetailByOrderCodes(Lists.newArrayList((Object[])new String[]{orderCode}));
        Validate.isTrue((!CollectionUtils.isEmpty(orderList) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((orderList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u51fa\u4e86\u591a\u6761\u6570\u636e\uff0c\u8fd9\u5e94\u8be5\u662f\u4e00\u4e2a\u6570\u636e\u9519\u8bef\u3002", (Object[])new Object[0]);
        return orderList.get(0);
    }

    private CostPoolCapitalDto getCapitalDto(Order order) {
        BigDecimal itemAmount = OrderAssist.getTallyItemAmount(order, this.capitalTallyItemRegister);
        if (itemAmount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return OrderAssist.getCostPoolCapitalDto(order, itemAmount, CapitalAdjustTypeEnum.ORDER_CLOSE);
    }

    private CreditPayDto getCreditPayDto(Order order) {
        BigDecimal itemAmount = OrderAssist.getTallyItemAmount(order, this.creditTallyItemRegister);
        if (itemAmount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return OrderAssist.getCreditPayDto(order, itemAmount, CashAdjustOperateEnum.CLOSE_ORDER, CashAdjustTypeEnum.CREDIT_RELEASE);
    }

    private CostPoolDiscountDto getDiscountDto(Order order) {
        BigDecimal itemAmount = OrderAssist.getTallyItemAmount(order, this.discountApportionTallyItemRegister);
        if (itemAmount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return OrderAssist.getCostPoolDiscountDto(order, itemAmount, PoolOperationTypeEnum.ORDER_CLOSE);
    }

    private List<CostPoolReplenishmentDto> getReplenishmentDto(Order order) {
        List<OrderDetail> orderDetails = order.getOrderDetails();
        if (CollectionUtils.isEmpty(orderDetails)) {
            return null;
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)orderDetails.size());
        for (OrderDetail orderDetail : orderDetails) {
            BigDecimal salesAmount = orderDetail.getSalesAmount();
            String itemType = orderDetail.getItemType();
            if (!itemType.equals(ItemTypeEnum.COMPENSATED_GOODS.getDictCode())) continue;
            CostPoolReplenishmentDto dto = OrderAssist.getCostPoolReplenishmentDto(order, orderDetail, salesAmount, com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum.ORDER_CLOSE);
            list.add(dto);
        }
        return list;
    }
}

