/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.biz.crm.dms.business.order.apportion.sdk.model.OrderApportionContext;
import com.biz.crm.dms.business.order.apportion.sdk.service.OrderApportionVoService;
import com.biz.crm.dms.business.order.apportion.sdk.service.OrderApportionVoServiceChain;
import com.biz.crm.dms.business.order.apportion.sdk.service.OrderApportionVoServiceChainInstance;
import com.biz.crm.dms.business.order.apportion.sdk.vo.OrderApportionVo;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCommitPhaseEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderPaymentMethodEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.common.sdk.model.TallyItemRegisterModel;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVo;
import com.biz.crm.dms.business.order.config.sdk.service.OrderValidateVoService;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderDetail;
import com.biz.crm.dms.business.order.local.entity.PurchaseHistory;
import com.biz.crm.dms.business.order.local.service.OrderFlowService;
import com.biz.crm.dms.business.order.local.service.OrderService;
import com.biz.crm.dms.business.order.local.service.PurchaseHistoryService;
import com.biz.crm.dms.business.order.local.service.assist.OrderAssist;
import com.biz.crm.dms.business.order.sdk.dto.OrderConfirmDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderPayConfirmDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderPreviewDto;
import com.biz.crm.dms.business.order.sdk.service.OrderConfirmService;
import com.biz.crm.dms.business.order.sdk.vo.OrderConfirmVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailPayPreviewVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailPreviewVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderPayPreviewVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderPreviewVo;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.service.OrderVerificationService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrderConfirmServiceImpl
implements OrderConfirmService {
    @Autowired(required=false)
    private OrderValidateVoService orderValidateVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private OrderVerificationService orderVerificationService;
    @Autowired(required=false)
    private List<OrderApportionVoService> orderApportionVoServiceList;
    @Autowired(required=false)
    private OrderApportionVoServiceChainInstance orderApportionVoServiceChainInstance;
    @Autowired(required=false)
    private OrderService orderService;
    @Autowired(required=false)
    private OrderFlowService orderFlowService;
    @Autowired(required=false)
    private PurchaseHistoryService purchaseHistoryService;
    @Autowired(required=false)
    private OrderAssist orderAssist;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Qualifier(value="DiscountApportionTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister discountTallyItemRegister;
    @Qualifier(value="CapitalTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister capitalTallyItemRegister;
    @Qualifier(value="CreditTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister creditTallyItemRegister;
    @Autowired(required=false)
    @Qualifier(value="costPoolCapitalStrategyImpl")
    private CostPoolStrategy costPoolCapitalStrategy;
    @Autowired(required=false)
    @Qualifier(value="costPoolCapitalRegisterImpl")
    private CostPoolRegister costPoolCapitalRegister;
    @Autowired(required=false)
    @Qualifier(value="CostPoolCreditStrategyImpl")
    private CostPoolStrategy costPoolCreditStrategy;
    @Autowired(required=false)
    @Qualifier(value="CostPoolCreditRegisterImpl")
    private CostPoolRegister costPoolCreditRegister;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    @Transactional
    public OrderConfirmVo handleConfirmWithPaymentMethod(OrderConfirmDto orderConfirmDto) {
        String orderPaymentMethod = orderConfirmDto.getOrderPaymentMethod();
        OrderConfirmVo orderConfirmVo = null;
        if (OrderPaymentMethodEnum.COST_POOL.getDictCode().equals(orderPaymentMethod)) {
            orderConfirmVo = this.handleConfirm(orderConfirmDto);
        }
        if (OrderPaymentMethodEnum.ONLINE_PAYMENT.getDictCode().equals(orderPaymentMethod)) {
            orderConfirmVo = this.handleConfirmWithoutCostPool(orderConfirmDto);
        }
        return orderConfirmVo;
    }

    private OrderConfirmVo handleConfirmWithoutCostPool(OrderConfirmDto order) {
        Order orderDb = this.setOrderCode(order);
        this.orderAssist.filterAndInitializeData((OrderPreviewDto)order);
        OrderConfigVo orderConfigVo = this.findOrderConfig(order);
        OrderDto orderContextDto = (OrderDto)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderDto.class, HashSet.class, LinkedList.class, new String[0]);
        OrderVerificationContext orderVerificationContext = this.validateOrder(orderContextDto, orderConfigVo, OrderValidationProcessNodeEnum.ONE);
        OrderApportionVo orderApportionVo = this.apportionPromotion(orderConfigVo, orderContextDto, OrderCommitPhaseEnum.CONFIRM);
        OrderConfirmVo orderConfirmVo = this.getOrderConfirmVo(order, orderApportionVo);
        this.buildTheSpecialOrderData(orderConfirmVo);
        this.tabulateData(orderConfirmVo);
        this.cleanTheSpecialOrderData(orderConfirmVo);
        ArrayList list = Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.THREE, OrderValidationProcessNodeEnum.TEN});
        this.rearValidate(order, list, orderVerificationContext, orderConfirmVo);
        this.saveOrder(order, orderDb, orderConfigVo, orderConfirmVo);
        this.orderFlowService.occupyResource(order, true);
        return orderConfirmVo;
    }

    public OrderConfirmVo handleSubmit(OrderConfirmDto order, List<OrderValidationProcessNodeEnum> exclude) {
        this.orderAssist.filterAndInitializeData((OrderPreviewDto)order);
        OrderConfigVo orderConfigVo = this.findOrderConfig(order);
        OrderDto orderContextDto = (OrderDto)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderDto.class, HashSet.class, LinkedList.class, new String[0]);
        OrderVerificationContext orderVerificationContext = this.validateOrder(orderContextDto, orderConfigVo, OrderValidationProcessNodeEnum.ONE);
        OrderApportionVo orderApportionVo = this.apportionPromotion(orderConfigVo, orderContextDto, OrderCommitPhaseEnum.SUBMIT);
        OrderConfirmVo orderConfirmVo = this.getOrderConfirmVo(order, orderApportionVo);
        this.buildTheSpecialOrderData(orderConfirmVo);
        this.tabulateData(orderConfirmVo);
        this.cleanTheSpecialOrderData(orderConfirmVo);
        this.setOrderPays((OrderPreviewVo)orderConfirmVo, order);
        this.rearValidate(order, exclude, orderVerificationContext, orderConfirmVo);
        this.findSkuMedia((OrderPreviewVo)orderConfirmVo);
        return orderConfirmVo;
    }

    private void rearValidate(OrderConfirmDto order, List<OrderValidationProcessNodeEnum> exclude, OrderVerificationContext orderVerificationContext, OrderConfirmVo orderConfirmVo) {
        OrderTabulateDto orderTabulateDto = (OrderTabulateDto)this.nebulaToolkitService.copyObjectByBlankList((Object)orderConfirmVo, OrderTabulateDto.class, HashSet.class, LinkedList.class, new String[0]);
        orderVerificationContext.setOrderTabulateDto(orderTabulateDto);
        OrderDto orderDto = (OrderDto)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderDto.class, HashSet.class, LinkedList.class, new String[0]);
        orderVerificationContext.setOrderDto(orderDto);
        ArrayList list = Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.TWO, OrderValidationProcessNodeEnum.THREE, OrderValidationProcessNodeEnum.FOUR, OrderValidationProcessNodeEnum.TEN});
        Collection subtract = org.apache.commons.collections.CollectionUtils.subtract((Collection)list, exclude);
        OrderValidationProcessNodeEnum[] orderValidationProcessNodeEnums = new OrderValidationProcessNodeEnum[subtract.size()];
        orderValidationProcessNodeEnums = subtract.toArray(orderValidationProcessNodeEnums);
        this.validateOrderByProcessNodes(orderVerificationContext, orderValidationProcessNodeEnums);
    }

    private void findSkuMedia(OrderPreviewVo orderPreviewVo) {
        List orderDetails = orderPreviewVo.getOrderDetails();
        List productCodeList = orderDetails.stream().map(OrderDetailPreviewVo::getGoodsCode).collect(Collectors.toList());
        List productList = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodeList);
        HashMap<String, ProductVo> productCodeMap = new HashMap<String, ProductVo>(productList.size());
        for (ProductVo productVo : productList) {
            productCodeMap.put(productVo.getProductCode(), productVo);
        }
        for (OrderDetailPreviewVo orderDetail : orderDetails) {
            String goodsCode = orderDetail.getGoodsCode();
            ProductVo productVo = (ProductVo)productCodeMap.get(goodsCode);
            if (ObjectUtils.isEmpty((Object)productVo)) continue;
            List<FileVo> pictureFileList = OrderAssist.getFileVos(productVo.getPictureMediaList());
            List<FileVo> videoFileList = OrderAssist.getFileVos(productVo.getVideoMediaList());
            orderDetail.setPictureMediaList(pictureFileList);
            orderDetail.setVideoMediaList(videoFileList);
        }
    }

    private OrderConfigVo findOrderConfig(OrderConfirmDto order) {
        String orderType = order.getOrderType();
        String relateCode = order.getRelateCode();
        OrderConfigVo orderValidateDto = this.orderValidateVoService.findByOrderTypeAndCustomerCode(orderType, relateCode);
        return orderValidateDto;
    }

    private void tabulateData(OrderConfirmVo orderConfirmVo) {
        BigDecimal totalCountGoods = BigDecimal.ZERO;
        BigDecimal totalOrderAmount = BigDecimal.ZERO;
        BigDecimal policyDiscountAmount = BigDecimal.ZERO;
        BigDecimal totalCompensatedAmount = BigDecimal.ZERO;
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        List orderPays = orderConfirmVo.getOrderPays();
        for (Object orderPay : orderPays) {
            Boolean itemGroupType = orderPay.getItemGroupType();
            if (itemGroupType.booleanValue()) continue;
            BigDecimal itemAmount = orderPay.getItemAmount();
            itemAmount = Objects.nonNull(itemAmount) ? itemAmount : BigDecimal.ZERO;
            totalDiscountAmount = totalDiscountAmount.add(itemAmount);
        }
        List orderDetails = orderConfirmVo.getOrderDetails();
        if (!CollectionUtils.isEmpty((Collection)orderDetails)) {
            for (OrderDetailPreviewVo orderDetail : orderDetails) {
                BigDecimal quantity = orderDetail.getQuantity();
                totalCountGoods = totalCountGoods.add(quantity);
                BigDecimal salesAmount = orderDetail.getSalesAmount();
                BigDecimal totalItemAmount = BigDecimal.ZERO;
                BigDecimal totalPolicyItemAmount = BigDecimal.ZERO;
                List orderDetailPays = orderDetail.getOrderDetailPays();
                if (!CollectionUtils.isEmpty((Collection)orderDetailPays)) {
                    for (OrderDetailPayPreviewVo orderDetailPay : orderDetailPays) {
                        Boolean available = orderDetailPay.getAvailable();
                        if (!available.booleanValue()) continue;
                        BigDecimal itemAmount = orderDetailPay.getItemAmount();
                        totalItemAmount = totalItemAmount.add(itemAmount);
                        String itemGroupKey = "salepolicyGroup";
                        boolean equals = itemGroupKey.equals(orderDetailPay.getItemGroupKey());
                        if (!equals) continue;
                        totalPolicyItemAmount = totalPolicyItemAmount.add(itemAmount);
                    }
                }
                BigDecimal shouldPaymentAmount = salesAmount.subtract(totalItemAmount);
                orderDetail.setShouldPaymentAmount(shouldPaymentAmount);
                orderDetail.setAverageUnitPrice(shouldPaymentAmount.divide(quantity, 4, RoundingMode.HALF_UP));
                policyDiscountAmount = policyDiscountAmount.add(totalPolicyItemAmount);
                totalOrderAmount = totalOrderAmount.add(salesAmount);
                String itemType = orderDetail.getItemType();
                if (!itemType.equals(ItemTypeEnum.COMPENSATED_GOODS.getDictCode())) continue;
                totalCompensatedAmount = totalCompensatedAmount.add(salesAmount);
            }
        }
        orderConfirmVo.setTotalOrderAmount(totalOrderAmount);
        BigDecimal actualAmountPaid = totalOrderAmount.subtract(policyDiscountAmount).subtract(totalCompensatedAmount).subtract(totalDiscountAmount);
        orderConfirmVo.setActualAmountPaid(actualAmountPaid);
        orderConfirmVo.setPolicyDiscountAmount(policyDiscountAmount);
        orderConfirmVo.setTotalCompensatedAmount(totalCompensatedAmount);
        orderConfirmVo.setTotalCountGoods(totalCountGoods);
        orderConfirmVo.setCreateTime(new Date());
        this.pruneNegativeAmount(orderConfirmVo);
    }

    private void pruneNegativeAmount(OrderConfirmVo orderConfirmVo) {
        String orderCategory = orderConfirmVo.getOrderCategory();
        boolean isMaterial = orderCategory.equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode());
        if (isMaterial) {
            return;
        }
        BigDecimal actualAmountPaid = orderConfirmVo.getActualAmountPaid();
        int compare = BigDecimal.ZERO.compareTo(actualAmountPaid);
        if (compare == 1) {
            return;
        }
        HashMap<String, BigDecimal> ToNegativeAmountMap = new HashMap<String, BigDecimal>();
        this.pruneNegativeAmount(orderConfirmVo, ToNegativeAmountMap, 0);
        if (!CollectionUtils.isEmpty(ToNegativeAmountMap)) {
            throw new IllegalArgumentException("\u8ba2\u5355\u53bb\u8d1f\u5206\u644a\uff0c\u5931\u8d25");
        }
    }

    private void pruneNegativeAmount(OrderConfirmVo orderConfirmVo, Map<String, BigDecimal> toNegativeAmountMap, int recursionTimes) {
        List orderDetails = orderConfirmVo.getOrderDetails();
        if (recursionTimes > orderDetails.size()) {
            return;
        }
        for (OrderDetailPreviewVo orderDetail : orderDetails) {
            this.lessThanZeroOperation(orderDetail, toNegativeAmountMap);
            this.equalToZeroOperation(orderDetail, toNegativeAmountMap);
            this.greaterThanZeroOperation(orderDetail, toNegativeAmountMap);
        }
        if (!CollectionUtils.isEmpty(toNegativeAmountMap)) {
            this.pruneNegativeAmount(orderConfirmVo, toNegativeAmountMap, ++recursionTimes);
        }
    }

    private void greaterThanZeroOperation(OrderDetailPreviewVo orderDetail, Map<String, BigDecimal> toNegativeAmountMap) {
        boolean isPositive;
        BigDecimal shouldPaymentAmount = orderDetail.getShouldPaymentAmount();
        boolean bl = isPositive = BigDecimal.ZERO.compareTo(shouldPaymentAmount) < 0;
        if (!isPositive) {
            return;
        }
        List orderDetailPays = orderDetail.getOrderDetailPays();
        if (CollectionUtils.isEmpty((Collection)orderDetailPays)) {
            return;
        }
        for (OrderDetailPayPreviewVo orderDetailPay : orderDetailPays) {
            BigDecimal surplusShouldPayment;
            BigDecimal surplus;
            BigDecimal itemAmount;
            BigDecimal adjust;
            String originData;
            shouldPaymentAmount = orderDetail.getShouldPaymentAmount();
            if (this.isZero(shouldPaymentAmount)) break;
            String itemKey = orderDetailPay.getItemKey();
            String mapKey = StringUtils.join((Object[])new String[]{itemKey, originData = orderDetailPay.getOriginData()});
            BigDecimal lendAmount = toNegativeAmountMap.get(mapKey);
            if (this.isZero(lendAmount)) continue;
            int compare = shouldPaymentAmount.compareTo(lendAmount);
            if (compare == 1) {
                adjust = lendAmount;
                itemAmount = orderDetailPay.getItemAmount();
                orderDetailPay.setItemAmount(itemAmount.add(adjust));
                surplus = lendAmount.subtract(adjust);
                if (this.isZero(surplus)) {
                    toNegativeAmountMap.remove(mapKey);
                } else {
                    toNegativeAmountMap.put(mapKey, surplus);
                }
                surplusShouldPayment = shouldPaymentAmount.subtract(adjust);
                orderDetail.setShouldPaymentAmount(surplusShouldPayment);
                continue;
            }
            adjust = shouldPaymentAmount;
            itemAmount = orderDetailPay.getItemAmount();
            orderDetailPay.setItemAmount(itemAmount.add(adjust));
            surplus = lendAmount.subtract(adjust);
            if (this.isZero(surplus)) {
                toNegativeAmountMap.remove(mapKey);
            } else {
                toNegativeAmountMap.put(mapKey, surplus);
            }
            surplusShouldPayment = shouldPaymentAmount.subtract(adjust);
            orderDetail.setShouldPaymentAmount(surplusShouldPayment);
        }
    }

    private void equalToZeroOperation(OrderDetailPreviewVo orderDetail, Map<String, BigDecimal> toNegativeAmountMap) {
        BigDecimal shouldPaymentAmount = orderDetail.getShouldPaymentAmount();
        if (!this.isZero(shouldPaymentAmount)) {
            return;
        }
        if (CollectionUtils.isEmpty(toNegativeAmountMap)) {
            return;
        }
        LinkedList lendList = Lists.newLinkedList();
        LinkedList borrowList = Lists.newLinkedList();
        BigDecimal lendTotalAmount = BigDecimal.ZERO;
        List orderDetailPays = orderDetail.getOrderDetailPays();
        for (OrderDetailPayPreviewVo orderDetailPay : orderDetailPays) {
            String originData;
            BigDecimal itemAmount = orderDetailPay.getItemAmount();
            String itemKey = orderDetailPay.getItemKey();
            String mapKey = StringUtils.join((Object[])new String[]{itemKey, originData = orderDetailPay.getOriginData()});
            boolean contains = toNegativeAmountMap.containsKey(mapKey);
            if (contains) {
                borrowList.add(orderDetailPay);
                lendTotalAmount = lendTotalAmount.add(toNegativeAmountMap.get(mapKey));
                continue;
            }
            int compare = BigDecimal.ZERO.compareTo(itemAmount);
            if (compare != -1) continue;
            lendList.add(orderDetailPay);
        }
        BigDecimal reduce = lendList.stream().map(OrderDetailPayPreviewVo::getItemAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal borrowAmount = lendTotalAmount.compareTo(reduce) == 1 ? reduce : lendTotalAmount;
        if (this.isZero(borrowAmount)) {
            return;
        }
        BigDecimal tempLend = borrowAmount.subtract(BigDecimal.ZERO);
        for (OrderDetailPayPreviewVo orderDetailPay : lendList) {
            if (this.isZero(tempLend)) break;
            String itemKey = orderDetailPay.getItemKey();
            String originData = orderDetailPay.getOriginData();
            String mapKey = StringUtils.join((Object[])new String[]{itemKey, originData});
            BigDecimal itemAmount = orderDetailPay.getItemAmount();
            int compare = tempLend.compareTo(itemAmount);
            BigDecimal adjust = compare == 1 ? itemAmount : tempLend;
            tempLend = tempLend.subtract(adjust);
            orderDetailPay.setItemAmount(itemAmount.subtract(adjust));
            toNegativeAmountMap.put(mapKey, adjust);
        }
        BigDecimal tempBorrow = borrowAmount.subtract(BigDecimal.ZERO);
        for (OrderDetailPayPreviewVo orderDetailPay : borrowList) {
            if (this.isZero(tempBorrow)) break;
            String itemKey = orderDetailPay.getItemKey();
            String originData = orderDetailPay.getOriginData();
            String mapKey = StringUtils.join((Object[])new String[]{itemKey, originData});
            BigDecimal lendAmount = toNegativeAmountMap.get(mapKey);
            int compare = tempBorrow.compareTo(lendAmount);
            BigDecimal adjust = compare == 1 ? lendAmount : tempBorrow;
            tempBorrow = tempBorrow.subtract(adjust);
            BigDecimal itemAmount = orderDetailPay.getItemAmount();
            orderDetailPay.setItemAmount(itemAmount.add(adjust));
            BigDecimal surplus = lendAmount.subtract(adjust);
            if (this.isZero(surplus)) {
                toNegativeAmountMap.remove(mapKey);
                continue;
            }
            toNegativeAmountMap.put(mapKey, surplus);
        }
    }

    private void lessThanZeroOperation(OrderDetailPreviewVo orderDetail, Map<String, BigDecimal> toNegativeAmountMap) {
        boolean isNegative;
        BigDecimal shouldPaymentAmount = orderDetail.getShouldPaymentAmount();
        boolean bl = isNegative = BigDecimal.ZERO.compareTo(shouldPaymentAmount) > 0;
        if (!isNegative) {
            return;
        }
        List orderDetailPays = orderDetail.getOrderDetailPays();
        for (OrderDetailPayPreviewVo orderDetailPay : orderDetailPays) {
            BigDecimal amassNegateAbs;
            BigDecimal adjust;
            boolean ge;
            shouldPaymentAmount = orderDetail.getShouldPaymentAmount();
            if (this.isZero(shouldPaymentAmount)) break;
            BigDecimal itemAmount = orderDetailPay.getItemAmount();
            if (this.isZero(itemAmount)) continue;
            String itemKey = orderDetailPay.getItemKey();
            String originData = orderDetailPay.getOriginData();
            String mapKey = StringUtils.join((Object[])new String[]{itemKey, originData});
            boolean bl2 = ge = itemAmount.compareTo(shouldPaymentAmount.abs()) > -1;
            if (ge) {
                adjust = shouldPaymentAmount.abs();
                orderDetailPay.setItemAmount(itemAmount.subtract(adjust));
                orderDetail.setShouldPaymentAmount(shouldPaymentAmount.add(adjust));
                amassNegateAbs = toNegativeAmountMap.get(mapKey);
                if (this.isZero(amassNegateAbs)) {
                    toNegativeAmountMap.put(mapKey, adjust);
                    continue;
                }
                toNegativeAmountMap.put(mapKey, amassNegateAbs.add(adjust));
                continue;
            }
            adjust = itemAmount;
            orderDetailPay.setItemAmount(itemAmount.subtract(adjust));
            orderDetail.setShouldPaymentAmount(shouldPaymentAmount.add(adjust));
            amassNegateAbs = toNegativeAmountMap.get(mapKey);
            if (this.isZero(amassNegateAbs)) {
                toNegativeAmountMap.put(mapKey, adjust);
                continue;
            }
            toNegativeAmountMap.put(mapKey, amassNegateAbs.add(adjust));
        }
        if (!this.isZero(shouldPaymentAmount = orderDetail.getShouldPaymentAmount())) {
            throw new IllegalArgumentException("\u4e0b\u5355\u65f6\uff0c\u5546\u54c1\u884c\u7684\u91d1\u989d\u59cb\u7ec8\u4e3a\u8d1f\u6570");
        }
    }

    private boolean isZero(BigDecimal bigDecimal) {
        boolean isZero = bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) == 0;
        return isZero;
    }

    @Transactional
    public OrderConfirmVo handleConfirm(OrderConfirmDto order) {
        Order orderDb = this.setOrderCode(order);
        this.orderAssist.filterAndInitializeData((OrderPreviewDto)order);
        OrderConfigVo orderConfigVo = this.findOrderConfig(order);
        OrderDto orderContextDto = (OrderDto)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderDto.class, HashSet.class, LinkedList.class, new String[0]);
        OrderVerificationContext orderVerificationContext = this.validateOrder(orderContextDto, orderConfigVo, OrderValidationProcessNodeEnum.ONE);
        OrderApportionVo orderApportionVo = this.apportionPromotion(orderConfigVo, orderContextDto, OrderCommitPhaseEnum.CONFIRM);
        OrderConfirmVo orderConfirmVo = this.getOrderConfirmVo(order, orderApportionVo);
        this.buildTheSpecialOrderData(orderConfirmVo);
        this.tabulateData(orderConfirmVo);
        this.cleanTheSpecialOrderData(orderConfirmVo);
        this.setOrderPays((OrderPreviewVo)orderConfirmVo, order);
        this.rearValidate(order, Lists.newLinkedList(), orderVerificationContext, orderConfirmVo);
        this.saveOrder(order, orderDb, orderConfigVo, orderConfirmVo);
        this.orderFlowService.pay(order);
        return orderConfirmVo;
    }

    private OrderVerificationContext validateOrder(OrderDto orderContextDto, OrderConfigVo orderConfigVo, OrderValidationProcessNodeEnum ... validationProcessNodes) {
        OrderVerificationContext orderVerificationContext = new OrderVerificationContext();
        orderVerificationContext.setOrderDto(orderContextDto);
        orderVerificationContext.setOrderConfigVo(orderConfigVo);
        return this.validateOrderByProcessNodes(orderVerificationContext, validationProcessNodes);
    }

    private OrderVerificationContext validateOrderByProcessNodes(OrderVerificationContext orderVerificationContext, OrderValidationProcessNodeEnum ... validationProcessNodes) {
        if (ArrayUtils.isEmpty((Object[])validationProcessNodes)) {
            return orderVerificationContext;
        }
        for (OrderValidationProcessNodeEnum validationProcessNode : validationProcessNodes) {
            orderVerificationContext.setProcessNodeEnum(validationProcessNode);
            this.orderVerificationService.execute(orderVerificationContext);
        }
        return orderVerificationContext;
    }

    private OrderApportionVo apportionPromotion(OrderConfigVo orderConfigVo, OrderDto orderContextDto, OrderCommitPhaseEnum phaseEnum) {
        OrderApportionContext context = new OrderApportionContext();
        context.setOrderConfigVo(orderConfigVo);
        context.setOrderDto(orderContextDto);
        context.setOrderCommitPhaseEnum(phaseEnum);
        OrderApportionVo orderApportionVo = this.apportion(context);
        return orderApportionVo;
    }

    private void saveOrder(OrderConfirmDto order, Order orderDb, OrderConfigVo orderConfigVo, OrderConfirmVo orderConfirmVo) {
        Order orderInsert = (Order)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)orderConfirmVo, Order.class, HashSet.class, LinkedList.class, new String[0]));
        if (Objects.nonNull((Object)orderDb)) {
            String orderStatus = orderDb.getOrderStatus();
            boolean isRejected = OrderStatusEnum.REJECTED.getDictCode().equals(orderStatus);
            boolean isCanceled = OrderStatusEnum.CANCELED.getDictCode().equals(orderStatus);
            if (orderDb.getDraft().booleanValue()) {
                this.orderService.deleteDraftByOrderCode(orderConfirmVo.getOrderCode());
                orderInsert.setId(orderDb.getId());
            } else if (isRejected || isCanceled) {
                orderInsert.setId(null);
            } else {
                String message = "[%s]\u72b6\u6001\u7684\u8ba2\u5355\u4e0d\u5141\u8bb8\u63d0\u4ea4";
                OrderStatusEnum orderStatusEnum = OrderStatusEnum.findByCode((String)orderStatus);
                throw new IllegalArgumentException(String.format(message, orderStatusEnum.getValue()));
            }
        }
        orderInsert.setDraft(false);
        if (ObjectUtils.isNotEmpty((Object)orderConfigVo)) {
            orderInsert.setSplitPrice(orderConfigVo.getIsKneadingPrice());
        }
        orderInsert.setQuantityOfCommodity(orderConfirmVo.getTotalCountGoods());
        orderInsert.setOrderStatus(OrderStatusEnum.AWAIT_APPROVE.getDictCode());
        orderInsert.setProcessKey(order.getProcessKey());
        orderInsert.setProcessRemark(order.getProcessRemark());
        this.orderService.create(orderInsert);
        orderConfirmVo.setId(orderInsert.getId());
        if (!order.getOrderCategory().equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode())) {
            this.recordPurchaseHistory(orderInsert);
        }
    }

    private OrderConfirmVo getOrderConfirmVo(OrderConfirmDto order, OrderApportionVo orderApportionVo) {
        OrderConfirmVo orderConfirmVo = (OrderConfirmVo)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderConfirmVo.class, HashSet.class, LinkedList.class, new String[0]);
        OrderConfirmVo apportionOrderConfirmVo = (OrderConfirmVo)this.nebulaToolkitService.copyObjectByBlankList((Object)orderApportionVo, OrderConfirmVo.class, HashSet.class, LinkedList.class, new String[0]);
        List inputOrderDetails = orderConfirmVo.getOrderDetails();
        List orderDetails = apportionOrderConfirmVo.getOrderDetails();
        List<OrderDetailPreviewVo> unionSet = OrderAssist.unionOrderDetails(inputOrderDetails, orderDetails);
        orderConfirmVo.setOrderDetails(unionSet);
        return orderConfirmVo;
    }

    @Transactional
    public OrderConfirmVo handleConfirmWithoutResource(OrderConfirmDto order) {
        Order orderDb = this.setOrderCode(order);
        this.orderAssist.filterAndInitializeData((OrderPreviewDto)order);
        OrderConfigVo orderConfigVo = this.findOrderConfig(order);
        OrderDto orderContextDto = (OrderDto)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderDto.class, HashSet.class, LinkedList.class, new String[0]);
        OrderVerificationContext orderVerificationContext = this.validateOrder(orderContextDto, orderConfigVo, OrderValidationProcessNodeEnum.ONE);
        OrderApportionVo orderApportionVo = this.apportionPromotion(orderConfigVo, orderContextDto, OrderCommitPhaseEnum.CONFIRM);
        OrderConfirmVo orderConfirmVo = this.getOrderConfirmVo(order, orderApportionVo);
        this.buildTheSpecialOrderData(orderConfirmVo);
        this.tabulateData(orderConfirmVo);
        this.cleanTheSpecialOrderData(orderConfirmVo);
        this.setOrderPays((OrderPreviewVo)orderConfirmVo, order);
        this.rearValidate(order, Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.THREE}), orderVerificationContext, orderConfirmVo);
        this.saveOrder(order, orderDb, orderConfigVo, orderConfirmVo);
        this.orderFlowService.occupyStock(order);
        return orderConfirmVo;
    }

    private void buildTheSpecialOrderData(OrderConfirmVo orderConfirmVo) {
        this.buildTheDiscountOrderData(orderConfirmVo);
    }

    private void cleanTheSpecialOrderData(OrderConfirmVo orderConfirmVo) {
        this.cleanTheFreeOrderData(orderConfirmVo);
    }

    private void buildTheDiscountOrderData(OrderConfirmVo orderConfirmVo) {
        String orderType = orderConfirmVo.getOrderType();
        boolean isDiscount = OrderTypeEnum.DISCOUNT.getDictCode().equals(orderType);
        if (!isDiscount) {
            return;
        }
        TallyItemRegisterModel tallyItemRegisterModel = this.discountTallyItemRegister.findTallyItemRegisterModel();
        List orderDetails = orderConfirmVo.getOrderDetails();
        for (OrderDetailPreviewVo orderDetail : orderDetails) {
            BigDecimal salesAmount = orderDetail.getSalesAmount();
            LinkedList orderDetailPayPreviewVos = Lists.newLinkedList();
            OrderDetailPayPreviewVo orderDetailPayPreviewVo = new OrderDetailPayPreviewVo();
            orderDetailPayPreviewVo.setOrderDetailCode(orderDetail.getOrderDetailCode());
            orderDetailPayPreviewVo.setOrderCode(orderConfirmVo.getOrderCode());
            orderDetailPayPreviewVo.setItemGroupKey(tallyItemRegisterModel.getItemGroupKey());
            orderDetailPayPreviewVo.setItemKey(tallyItemRegisterModel.getItemKey());
            orderDetailPayPreviewVo.setItemName(tallyItemRegisterModel.getItemName());
            orderDetailPayPreviewVo.setItemAmount(salesAmount);
            orderDetailPayPreviewVo.setAvailable(Boolean.valueOf(true));
            orderDetailPayPreviewVos.add(orderDetailPayPreviewVo);
            orderDetail.setOrderDetailPays((List)orderDetailPayPreviewVos);
        }
    }

    private void cleanTheFreeOrderData(OrderConfirmVo orderConfirmVo) {
        String orderType = orderConfirmVo.getOrderType();
        boolean isFree = OrderTypeEnum.FREE.getDictCode().equals(orderType);
        if (!isFree) {
            return;
        }
        List orderDetails = orderConfirmVo.getOrderDetails();
        for (OrderDetailPreviewVo orderDetail : orderDetails) {
            orderDetail.setShouldPaymentAmount(BigDecimal.ZERO);
        }
        orderConfirmVo.setActualAmountPaid(BigDecimal.ZERO);
    }

    public OrderConfirmVo createOrUpdate(OrderConfirmDto order) {
        Order orderInsert = (Order)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)order, Order.class, HashSet.class, LinkedList.class, new String[0]));
        Order orderResult = this.orderService.create(orderInsert);
        return (OrderConfirmVo)this.nebulaToolkitService.copyObjectByBlankList((Object)orderResult, OrderConfirmVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void setOrderPays(OrderPreviewVo order, OrderConfirmDto orderConfirmDto) {
        BigDecimal totalUsableAmount;
        int compare;
        List orderPays = order.getOrderPays();
        if (CollectionUtils.isEmpty((Collection)orderPays)) {
            orderPays = Lists.newLinkedList();
            order.setOrderPays(orderPays);
        }
        Iterator iterator = orderPays.iterator();
        while (iterator.hasNext()) {
            OrderPayPreviewVo next = (OrderPayPreviewVo)iterator.next();
            Boolean itemGroupType = next.getItemGroupType();
            if (!itemGroupType.booleanValue()) continue;
            iterator.remove();
        }
        String orderType = order.getOrderType();
        boolean isFree = OrderTypeEnum.FREE.getDictCode().equals(orderType);
        if (isFree) {
            return;
        }
        TallyItemRegisterModel capitalTallyItem = this.capitalTallyItemRegister.findTallyItemRegisterModel();
        OrderPayPreviewVo capital = new OrderPayPreviewVo();
        Boolean pay = this.isPay(capitalTallyItem);
        capital.setItemGroupType(pay);
        capital.setItemGroupKey(capitalTallyItem.getItemGroupKey());
        capital.setItemKey(capitalTallyItem.getItemKey());
        capital.setItemName(capitalTallyItem.getItemName());
        orderPays.add(capital);
        TallyItemRegisterModel creditTallyItem = this.creditTallyItemRegister.findTallyItemRegisterModel();
        OrderPayPreviewVo credit = new OrderPayPreviewVo();
        Boolean isPay = this.isPay(creditTallyItem);
        credit.setItemGroupType(isPay);
        credit.setItemGroupKey(creditTallyItem.getItemGroupKey());
        credit.setItemKey(creditTallyItem.getItemKey());
        credit.setItemName(creditTallyItem.getItemName());
        orderPays.add(credit);
        BigDecimal actualAmountPaid = order.getActualAmountPaid();
        BigDecimal capitalUsableAmount = this.findUsableAmount(this.costPoolCapitalRegister, order.getRelateCode(), this.costPoolCapitalStrategy);
        BigDecimal creditUsableAmount = this.findUsableAmount(this.costPoolCreditRegister, order.getRelateCode(), this.costPoolCreditStrategy);
        List refundOrderPays = orderConfirmDto.getRefundOrderPays();
        if (!CollectionUtils.isEmpty((Collection)refundOrderPays)) {
            for (OrderPayConfirmDto refundOrderPay : refundOrderPays) {
                boolean isCredit;
                BigDecimal itemAmount = refundOrderPay.getItemAmount();
                Boolean itemGroupType = refundOrderPay.getItemGroupType();
                if (itemGroupType == null && !itemGroupType.booleanValue()) continue;
                boolean isCapital = capitalTallyItem.getItemKey().equals(refundOrderPay.getItemKey());
                if (isCapital) {
                    capitalUsableAmount = capitalUsableAmount.add(itemAmount);
                }
                if (!(isCredit = creditTallyItem.getItemKey().equals(refundOrderPay.getItemKey()))) continue;
                creditUsableAmount = creditUsableAmount.add(itemAmount);
            }
        }
        if ((compare = actualAmountPaid.compareTo(totalUsableAmount = capitalUsableAmount.add(creditUsableAmount))) > 0) {
            throw new IllegalArgumentException("\u4f59\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u652f\u4ed8\u8ba2\u5355");
        }
        if (compare < 0) {
            int compareCapital = actualAmountPaid.compareTo(capitalUsableAmount);
            if (compareCapital > 0) {
                capital.setItemAmount(capitalUsableAmount);
                credit.setItemAmount(actualAmountPaid.subtract(capitalUsableAmount));
            } else if (compareCapital < 0) {
                capital.setItemAmount(actualAmountPaid);
                credit.setItemAmount(BigDecimal.ZERO);
            } else {
                capital.setItemAmount(actualAmountPaid);
                credit.setItemAmount(BigDecimal.ZERO);
            }
        } else {
            capital.setItemAmount(capitalUsableAmount);
            credit.setItemAmount(creditUsableAmount);
        }
        List orderConfirmDtos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)orderPays, OrderPayPreviewVo.class, OrderPayConfirmDto.class, HashSet.class, LinkedList.class, new String[0]);
        orderConfirmDto.setOrderPays(orderConfirmDtos);
    }

    private Boolean isPay(TallyItemRegisterModel creditTallyItem) {
        Integer itemGroupTypeInt = Integer.valueOf(creditTallyItem.getTallyItemGroupType().getDictCode());
        Boolean isPay = itemGroupTypeInt != 0;
        return isPay;
    }

    private BigDecimal findUsableAmount(CostPoolRegister costPoolRegister, String customerCode, CostPoolStrategy costPoolStrategy) {
        CostPoolDto costPoolDto = new CostPoolDto();
        costPoolDto.setPoolType(costPoolRegister.getKey());
        costPoolDto.setCustomerCode(customerCode);
        List costPoolVos = costPoolStrategy.onRequestCostPoolVos(costPoolDto);
        if (CollectionUtils.isEmpty((Collection)costPoolVos)) {
            return BigDecimal.ZERO;
        }
        BigDecimal usableAmount = costPoolVos.stream().map(CostPoolVo::getUsableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return usableAmount;
    }

    private Order setOrderCode(OrderConfirmDto order) {
        this.generateOrderCode(order);
        Order orderDb = this.orderService.findByOrderCode(order.getOrderCode());
        if (Objects.nonNull((Object)orderDb)) {
            String orderStatus = orderDb.getOrderStatus();
            boolean isRejected = OrderStatusEnum.REJECTED.getDictCode().equals(orderStatus);
            boolean isCanceled = OrderStatusEnum.CANCELED.getDictCode().equals(orderStatus);
            if (isRejected || isCanceled) {
                order.setOrderCode(null);
            }
            this.generateOrderCode(order);
        }
        return orderDb;
    }

    private void compensationPaymentAccuracy(OrderConfirmVo orderConfirmVo) {
        BigDecimal compensationValue;
        String orderCategory = orderConfirmVo.getOrderCategory();
        if (orderCategory.equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode())) {
            return;
        }
        String orderType = orderConfirmVo.getOrderType();
        boolean isFree = OrderTypeEnum.FREE.getDictCode().equals(orderType);
        if (isFree) {
            return;
        }
        List orderPays = orderConfirmVo.getOrderPays();
        BigDecimal totalOrderAmount = orderConfirmVo.getTotalOrderAmount();
        BigDecimal policyDiscountAmount = orderConfirmVo.getPolicyDiscountAmount();
        BigDecimal totalCompensatedAmount = orderConfirmVo.getTotalCompensatedAmount();
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        for (Object orderPay : orderPays) {
            Boolean itemGroupType = orderPay.getItemGroupType();
            if (itemGroupType.booleanValue()) continue;
            BigDecimal itemAmount = orderPay.getItemAmount();
            itemAmount = Objects.nonNull(itemAmount) ? itemAmount : BigDecimal.ZERO;
            totalDiscountAmount = totalDiscountAmount.add(itemAmount);
        }
        BigDecimal totalPaymentAmount = BigDecimal.ZERO;
        for (OrderPayPreviewVo orderPay : orderPays) {
            Boolean itemGroupType = orderPay.getItemGroupType();
            if (!itemGroupType.booleanValue()) continue;
            BigDecimal itemAmount = orderPay.getItemAmount();
            itemAmount = Objects.nonNull(itemAmount) ? itemAmount : BigDecimal.ZERO;
            totalPaymentAmount = totalPaymentAmount.add(itemAmount);
        }
        BigDecimal amountPayable = totalOrderAmount.subtract(policyDiscountAmount).subtract(totalCompensatedAmount).subtract(totalDiscountAmount);
        int compare = amountPayable.compareTo(totalPaymentAmount);
        BigDecimal threshold = new BigDecimal("0.1");
        if (compare == 0) {
            return;
        }
        if (compare > 0) {
            boolean canCompensate;
            compensationValue = amountPayable.subtract(totalPaymentAmount);
            boolean bl = canCompensate = threshold.compareTo(compensationValue) > -1;
            if (!canCompensate) {
                return;
            }
            for (OrderPayPreviewVo orderPay : orderPays) {
                Boolean itemGroupType = orderPay.getItemGroupType();
                if (!itemGroupType.booleanValue()) continue;
                BigDecimal itemAmount = orderPay.getItemAmount();
                itemAmount = Objects.nonNull(itemAmount) ? itemAmount : BigDecimal.ZERO;
                orderPay.setItemAmount(itemAmount.add(compensationValue));
                break;
            }
        } else {
            boolean canCompensate;
            compensationValue = totalPaymentAmount.subtract(amountPayable);
            boolean bl = canCompensate = threshold.compareTo(compensationValue) > -1;
            if (!canCompensate) {
                return;
            }
            for (OrderPayPreviewVo orderPay : orderPays) {
                BigDecimal itemAmount;
                boolean ge;
                Boolean itemGroupType = orderPay.getItemGroupType();
                if (!itemGroupType.booleanValue() || !(ge = (itemAmount = Objects.nonNull(itemAmount = orderPay.getItemAmount()) ? itemAmount : BigDecimal.ZERO).compareTo(compensationValue) > -1)) continue;
                orderPay.setItemAmount(itemAmount.subtract(compensationValue));
                break;
            }
        }
    }

    @Transactional
    public OrderConfirmVo handleConfirmByCurrentCustomer(OrderConfirmDto order) {
        LoginUserDetailsForEMS loginDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        order.setRelateCode(loginDetails.getCustomerCode());
        order.setRelateName(loginDetails.getCustomerName());
        List dmsWorkFlow = this.dictDataVoService.findByDictTypeCode("dms_work_flow");
        if (!CollectionUtils.isEmpty((Collection)dmsWorkFlow)) {
            for (DictDataVo dictDataVo : dmsWorkFlow) {
                String dictCode = dictDataVo.getDictCode();
                if ("customerOrderKey".equals(dictCode)) {
                    order.setProcessKey(dictDataVo.getDictValue());
                    continue;
                }
                if (!"customerOrderForm".equals(dictCode)) continue;
                order.setCompetenceCode(dictDataVo.getDictValue());
            }
        } else {
            order.setProcessKey("orderapprove");
            order.setCompetenceCode("CRM202101050000000425");
        }
        return this.handleConfirmWithPaymentMethod(order);
    }

    public OrderConfirmVo handlePartSubmitByCurrentCustomer(OrderConfirmDto order) {
        LoginUserDetailsForEMS loginDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        order.setRelateCode(loginDetails.getCustomerCode());
        order.setRelateName(loginDetails.getCustomerName());
        ArrayList exclude = Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.TEN});
        return this.handleSubmit(order, exclude);
    }

    private void recordPurchaseHistory(Order orderInsert) {
        List<OrderDetail> details = orderInsert.getOrderDetails();
        ArrayList purchaseHistories = Lists.newArrayListWithCapacity((int)details.size());
        for (OrderDetail detail : details) {
            PurchaseHistory purchaseHistory = new PurchaseHistory();
            purchaseHistory.setGoodsCode(detail.getGoodsCode());
            purchaseHistory.setGoodsName(detail.getGoodsName());
            purchaseHistory.setSpec(detail.getSpec());
            purchaseHistory.setUnite(detail.getUnite());
            purchaseHistory.setRelateCode(orderInsert.getRelateCode());
            purchaseHistory.setTenantCode(TenantUtils.getTenantCode());
            purchaseHistory.setAppCode(TenantUtils.getAppCode());
            purchaseHistories.add(purchaseHistory);
        }
        this.purchaseHistoryService.handleIncrement(purchaseHistories);
    }

    private void generateOrderCode(OrderConfirmDto order) {
        if (StringUtils.isBlank((CharSequence)order.getOrderCode())) {
            String ruleCode = StringUtils.join((Object[])new String[]{"OD", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
            String orderCode = (String)this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(10), 2L, TimeUnit.DAYS).get(0);
            order.setOrderCode(orderCode);
        }
    }

    private OrderApportionVo apportion(OrderApportionContext context) {
        Validate.isTrue((!CollectionUtils.isEmpty(this.orderApportionVoServiceList) ? 1 : 0) != 0, (String)"\u8fd8\u6ca1\u6709\u5206\u644a\u5b9e\u73b0\uff0c\u8bf7\u786e\u8ba4\u9879\u76ee\u662f\u5426\u6b63\u786e\u6784\u5efa", (Object[])new Object[0]);
        Collections.sort(this.orderApportionVoServiceList);
        OrderApportionVoServiceChain chain = this.orderApportionVoServiceChainInstance.getChain(this.orderApportionVoServiceList);
        chain.execute(context);
        return context.getOrderApportionVo();
    }
}

