/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.local.entity.OrderDetail;
import com.biz.crm.dms.business.order.local.entity.OrderDetailPay;
import com.biz.crm.dms.business.order.local.repository.OrderDetailPayRepository;
import com.biz.crm.dms.business.order.local.service.OrderDetailPayService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orderDetailPayService")
public class OrderDetailPayServiceImpl
implements OrderDetailPayService {
    @Autowired(required=false)
    private OrderDetailPayRepository orderDetailPayRepository;

    @Override
    public Page<OrderDetailPay> findByConditions(Pageable pageable, OrderDetailPay orderDetailPay) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)orderDetailPay)) {
            orderDetailPay = new OrderDetailPay();
        }
        return this.orderDetailPayRepository.findByConditions(pageable, orderDetailPay);
    }

    @Override
    public OrderDetailPay findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (OrderDetailPay)((Object)this.orderDetailPayRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public OrderDetailPay create(OrderDetailPay orderDetailPay) {
        this.createValidate(orderDetailPay);
        this.orderDetailPayRepository.saveOrUpdate((Object)orderDetailPay);
        return orderDetailPay;
    }

    @Override
    @Transactional
    public OrderDetailPay update(OrderDetailPay orderDetailPay) {
        this.updateValidate(orderDetailPay);
        this.orderDetailPayRepository.saveOrUpdate((Object)orderDetailPay);
        return orderDetailPay;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.orderDetailPayRepository.removeByIds(idList);
    }

    @Override
    @Transactional
    public void createBatch(List<OrderDetail> orderDetails) {
        Validate.isTrue((!CollectionUtils.isEmpty(orderDetails) ? 1 : 0) != 0, (String)"\u65b0\u589e\u65f6\uff0c\u6ca1\u6709\u4fe1\u606f\u4f20\u5165\uff01", (Object[])new Object[0]);
        for (OrderDetail orderDetail : orderDetails) {
            this.saveOrUpdateBatch(orderDetail);
        }
    }

    @Override
    @Transactional
    public void deleteByOrderCode(String orderCode) {
        Validate.notBlank((CharSequence)orderCode, (String)"\u5220\u9664\u65f6\uff0c\u8981\u4f20\u5165\u8ba2\u5355\u7f16\u7801", (Object[])new Object[0]);
        this.orderDetailPayRepository.deleteByOrderCode(orderCode);
    }

    private void saveOrUpdateBatch(OrderDetail orderDetail) {
        List<OrderDetailPay> orderDetailPays = orderDetail.getOrderDetailPays();
        if (CollectionUtils.isEmpty(orderDetailPays)) {
            return;
        }
        for (OrderDetailPay orderDetailPay : orderDetailPays) {
            orderDetailPay.setTenantCode(orderDetail.getTenantCode());
            orderDetailPay.setAppCode(orderDetail.getAppCode());
            orderDetailPay.setOrderCode(orderDetail.getOrderCode());
            orderDetailPay.setOrderDetailCode(orderDetail.getOrderDetailCode());
            this.createValidate(orderDetailPay);
        }
        this.orderDetailPayRepository.saveOrUpdateBatch(orderDetailPays);
    }

    private void createValidate(OrderDetailPay orderDetailPay) {
        Validate.notNull((Object)((Object)orderDetailPay), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetailPay.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetailPay.getAppCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u54c1\u724c\u5546\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetailPay.getOrderDetailCode(), (String)"\u660e\u7ec6\u7f16\u7801,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetailPay.getOrderCode(), (String)"\u8ba2\u5355\u7f16\u7801,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String itemGroupKey = orderDetailPay.getItemGroupKey();
        String itemKey = orderDetailPay.getItemKey();
        String itemName = orderDetailPay.getItemName();
        BigDecimal itemAmount = orderDetailPay.getItemAmount();
        String originData = orderDetailPay.getOriginData();
        Validate.notBlank((CharSequence)itemGroupKey, (String)"\u8be5\u6263\u9879\u76ee\u7ec4\u7684key,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemKey, (String)"\u8be5\u6263\u9879\u76eekey,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemName, (String)"\u8be5\u6263\u9879\u76ee\u540d\u79f0,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)itemAmount, (String)"\u8be5\u6263\u9879\u76ee\u91d1\u989d\uff08\u7ec4\u5185\u5206\u644a\uff09,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((itemGroupKey.length() < 32 ? 1 : 0) != 0, (String)"\u8be5\u6263\u9879\u76ee\u7ec4\u7684key,\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((itemKey.length() < 32 ? 1 : 0) != 0, (String)"\u8be5\u6263\u9879\u76eekey,\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((itemName.length() < 32 ? 1 : 0) != 0, (String)"\u8be5\u6263\u9879\u76ee\u540d\u79f0,\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isEmpty((CharSequence)originData) || originData.length() < 255 ? 1 : 0) != 0, (String)"\u8be5\u6263\u9879\u76ee\u91d1\u989d\u6570\u636e\u7684\u7531\u6765,\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(OrderDetailPay orderDetailPay) {
        Validate.notNull((Object)((Object)orderDetailPay), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetailPay.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetailPay.getTenantCode(), (String)"\u4fee\u6539\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetailPay.getAppCode(), (String)"\u4fee\u6539\u65f6\uff0c\u54c1\u724c\u5546\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

