/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderDetail;
import com.biz.crm.dms.business.order.local.repository.OrderDetailRepository;
import com.biz.crm.dms.business.order.local.service.OrderDetailPayService;
import com.biz.crm.dms.business.order.local.service.OrderDetailService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orderDetailService")
public class OrderDetailServiceImpl
implements OrderDetailService {
    @Autowired(required=false)
    private OrderDetailRepository orderDetailRepository;
    @Autowired(required=false)
    private OrderDetailPayService orderDetailPayService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    public Page<OrderDetail> findByConditions(Pageable pageable, OrderDetail orderDetail) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)orderDetail)) {
            orderDetail = new OrderDetail();
        }
        return this.orderDetailRepository.findByConditions(pageable, orderDetail);
    }

    @Override
    public OrderDetail findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (OrderDetail)((Object)this.orderDetailRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public OrderDetail create(OrderDetail orderDetail) {
        this.createValidate(orderDetail);
        this.orderDetailRepository.saveOrUpdate((Object)orderDetail);
        return orderDetail;
    }

    @Override
    @Transactional
    public OrderDetail update(OrderDetail orderDetail) {
        this.updateValidate(orderDetail);
        this.orderDetailRepository.saveOrUpdate((Object)orderDetail);
        return orderDetail;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.orderDetailRepository.removeByIds(idList);
    }

    @Override
    @Transactional
    public void createBatch(Order order) {
        Validate.notNull((Object)((Object)order), (String)"\u6279\u91cf\u6301\u4e45\u5316\u8ba2\u5355\u660e\u7ec6\u65f6\uff0c\u8ba2\u5355\u4e3b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean draft = order.getDraft();
        List<OrderDetail> orderDetails = order.getOrderDetails();
        if (draft.booleanValue() && CollectionUtils.isEmpty(orderDetails)) {
            return;
        }
        Validate.isTrue((!CollectionUtils.isEmpty(orderDetails) ? 1 : 0) != 0, (String)"\u6279\u91cf\u6301\u4e45\u5316\u8ba2\u5355\u660e\u7ec6\u65f6,\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (OrderDetail orderDetail : orderDetails) {
            orderDetail.setTenantCode(order.getTenantCode());
            orderDetail.setAppCode(order.getAppCode());
            orderDetail.setOrderCode(order.getOrderCode());
            this.setOrderDetailCode(orderDetail);
            this.createValidate(orderDetail);
            if (!draft.booleanValue()) {
                this.requiredValidate(orderDetail);
            }
            if (!order.getOrderCategory().equals(OrderCategoryEnum.SALES_ORDER.getDictCode())) continue;
            Validate.notBlank((CharSequence)orderDetail.getSpec(), (String)"\u89c4\u683c,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        this.orderDetailRepository.saveOrUpdateBatch(orderDetails);
        this.saveOrderDetailPay(orderDetails);
    }

    @Override
    @Transactional
    public void deleteByOrderCode(String orderCode) {
        Validate.notBlank((CharSequence)orderCode, (String)"\u5220\u9664\u65f6\uff0c\u8981\u4f20\u5165\u8ba2\u5355\u7f16\u7801", (Object[])new Object[0]);
        this.orderDetailPayService.deleteByOrderCode(orderCode);
        this.orderDetailRepository.deleteByOrderCode(orderCode);
    }

    private void setOrderDetailCode(OrderDetail orderDetail) {
        String ruleCode = StringUtils.join((Object[])new String[]{"OG", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String orderDetailCode = (String)this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        orderDetail.setOrderDetailCode(orderDetailCode);
    }

    private void requiredValidate(OrderDetail orderDetail) {
        BigDecimal presetUnitPrice = orderDetail.getPresetUnitPrice();
        BigDecimal averageUnitPrice = orderDetail.getAverageUnitPrice();
        BigDecimal salesAmount = orderDetail.getSalesAmount();
        BigDecimal shouldPaymentAmount = orderDetail.getShouldPaymentAmount();
        Validate.notNull((Object)presetUnitPrice, (String)"\u6210\u672c\u5355\u4ef7,\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)averageUnitPrice, (String)"\u5e73\u5747\u4ef7,\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)salesAmount, (String)"\u9500\u552e\u91d1\u989d,\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)shouldPaymentAmount, (String)"\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\uff08\u9500\u552e\u91d1\u989d - \u4f18\u60e0\u91d1\u989d - \u62b5\u6263\u91d1\u989d\uff09,\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void saveOrderDetailPay(List<OrderDetail> orderDetails) {
        if (CollectionUtils.isEmpty(orderDetails)) {
            return;
        }
        this.orderDetailPayService.createBatch(orderDetails);
    }

    private void createValidate(OrderDetail orderDetail) {
        Validate.notNull((Object)((Object)orderDetail), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetail.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetail.getAppCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u54c1\u724c\u5546\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetail.getOrderCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String orderDetailCode = orderDetail.getOrderDetailCode();
        String itemType = orderDetail.getItemType();
        String itemCode = orderDetail.getItemCode();
        String goodsCode = orderDetail.getGoodsCode();
        String goodsName = orderDetail.getGoodsName();
        String spec = orderDetail.getSpec();
        String unite = orderDetail.getUnite();
        BigDecimal quantity = orderDetail.getQuantity();
        boolean gtZero = quantity.compareTo(BigDecimal.ZERO) > -1;
        Validate.isTrue((boolean)gtZero, (String)"\u8ba2\u8d2d\u6570\u91cf\uff0c\u4e0d\u80fd\u5c0f\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetailCode, (String)"\u660e\u7ec6\u7f16\u7801,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemType, (String)"\u884c\u9879\u76ee\u7c7b\u578b,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)goodsCode, (String)"\u5546\u54c1/\u7269\u6599\u7f16\u7801,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)goodsName, (String)"\u5546\u54c1/\u7269\u6599\u540d\u79f0,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)unite, (String)"\u9500\u552e\u5355\u4f4d,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((orderDetailCode.length() < 255 ? 1 : 0) != 0, (String)"\u660e\u7ec6\u7f16\u7801,\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((itemType.length() < 64 ? 1 : 0) != 0, (String)"\u884c\u9879\u76ee\u7c7b\u578b,\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)itemCode) || itemCode.length() < 64 ? 1 : 0) != 0, (String)"\u884c\u9879\u76ee\u7c7b\u578b\u7684\u7279\u6709\u4e1a\u52a1\u7f16\u7801,\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((goodsCode.length() < 64 ? 1 : 0) != 0, (String)"\u5546\u54c1/\u7269\u6599\u7f16\u7801,\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((goodsName.length() < 100 ? 1 : 0) != 0, (String)"\u5546\u54c1/\u7269\u6599\u540d\u79f0,\u9650\u5b9a\u957f\u5ea6(100)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)spec) || spec.length() < 64 ? 1 : 0) != 0, (String)"\u89c4\u683c,\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((unite.length() < 64 ? 1 : 0) != 0, (String)"\u9500\u552e\u5355\u4f4d,\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(OrderDetail orderDetail) {
        Validate.notNull((Object)((Object)orderDetail), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetail.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetail.getTenantCode(), (String)"\u4fee\u6539\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderDetail.getAppCode(), (String)"\u4fee\u6539\u65f6\uff0c\u54c1\u724c\u5546\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

