/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderFile;
import com.biz.crm.dms.business.order.local.repository.OrderFileRepository;
import com.biz.crm.dms.business.order.local.service.OrderFileService;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orderFileService")
public class OrderFileServiceImpl
implements OrderFileService {
    @Autowired(required=false)
    private OrderFileRepository orderFileRepository;

    @Override
    public Page<OrderFile> findByConditions(Pageable pageable, OrderFile orderFile) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)orderFile)) {
            orderFile = new OrderFile();
        }
        return this.orderFileRepository.findByConditions(pageable, orderFile);
    }

    @Override
    public OrderFile findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (OrderFile)((Object)this.orderFileRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public OrderFile create(OrderFile orderFile) {
        this.createValidate(orderFile);
        this.orderFileRepository.saveOrUpdate((Object)orderFile);
        return orderFile;
    }

    @Override
    @Transactional
    public OrderFile update(OrderFile orderFile) {
        this.updateValidate(orderFile);
        this.orderFileRepository.saveOrUpdate((Object)orderFile);
        return orderFile;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.orderFileRepository.removeByIds(idList);
    }

    @Override
    @Transactional
    public void createBatch(Order order) {
        Validate.notNull((Object)((Object)order), (String)"\u6279\u91cf\u6301\u4e45\u5316\u8ba2\u5355\u9644\u4ef6\u65f6\uff0c\u8ba2\u5355\u4e3b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<OrderFile> orderFiles = order.getOrderFiles();
        if (CollectionUtils.isEmpty(orderFiles)) {
            return;
        }
        Iterator<OrderFile> iterator = orderFiles.iterator();
        while (iterator.hasNext()) {
            OrderFile next = iterator.next();
            if (Objects.isNull((Object)next)) {
                iterator.remove();
                continue;
            }
            next.setTenantCode(order.getTenantCode());
            next.setAppCode(order.getAppCode());
            next.setOrderCode(order.getOrderCode());
            this.createValidate(next);
        }
        this.orderFileRepository.saveOrUpdateBatch(orderFiles);
    }

    @Override
    @Transactional
    public void deleteByOrderCode(String orderCode) {
        Validate.notBlank((CharSequence)orderCode, (String)"\u5220\u9664\u65f6\uff0c\u8981\u4f20\u5165\u8ba2\u5355\u7f16\u7801", (Object[])new Object[0]);
        this.orderFileRepository.deleteByOrderCode(orderCode);
    }

    private void createValidate(OrderFile orderFile) {
        Validate.notNull((Object)((Object)orderFile), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getAppCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u54c1\u724c\u5546\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getOrderCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getFileName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u6587\u4ef6\u540d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getRelativePath(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u76f8\u5bf9\u8def\u5f84 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(OrderFile orderFile) {
        Validate.notNull((Object)((Object)orderFile), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getAppCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u54c1\u724c\u5546\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getFileName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u6587\u4ef6\u540d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getRelativePath(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u76f8\u5bf9\u8def\u5f84 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

