/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPayDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderDetail;
import com.biz.crm.dms.business.order.local.repository.OrderRepository;
import com.biz.crm.dms.business.order.local.service.OrderFlowService;
import com.biz.crm.dms.business.order.local.service.assist.OrderAssist;
import com.biz.crm.dms.business.order.sdk.dto.OrderConfirmDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.biz.crm.workflow.sdk.dto.StartProcessDto;
import com.biz.crm.workflow.sdk.listener.ProcessListener;
import com.biz.crm.workflow.sdk.vo.response.CommitWorkflowResponse;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrderFlowServiceImpl
implements OrderFlowService {
    @Autowired(required=false)
    private OrderRepository orderRepository;
    @Autowired(required=false)
    private ProductStockVoService productStockVoService;
    @Autowired(required=false)
    private CostPoolVoService costPoolVoService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private OrderAssist orderAssist;
    @Qualifier(value="DiscountApportionTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister discountApportionTallyItemRegister;
    @Qualifier(value="CreditTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister creditTallyItemRegister;
    @Qualifier(value="CapitalTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister capitalTallyItemRegister;

    @Override
    @Transactional
    public void pay(OrderConfirmDto orderConfirmDto) {
        String orderCode = orderConfirmDto.getOrderCode();
        Validate.notBlank((CharSequence)orderCode, (String)"\u652f\u4ed8\u8ba2\u5355\u65f6\uff0c\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Order> orders = this.orderRepository.findDetailByOrderCodes(Lists.newArrayList((Object[])new String[]{orderCode}));
        Validate.isTrue((!CollectionUtils.isEmpty(orders) ? 1 : 0) != 0, (String)"\u652f\u4ed8\u8ba2\u5355\u65f6\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f", (Object[])new Object[0]);
        for (Order order : orders) {
            String orderType = order.getOrderType();
            boolean isFree = OrderTypeEnum.FREE.getDictCode().equals(orderType);
            String orderCategory = order.getOrderCategory();
            boolean isMaterial = OrderCategoryEnum.MATERIAL_ORDER.getDictCode().equals(orderCategory);
            if (!isFree && !isMaterial) {
                this.occupyOrder(order);
            }
            this.occupyStock(order);
            this.commitProcess(orderConfirmDto, order);
        }
    }

    @Override
    @Transactional
    public void occupyResource(OrderConfirmDto orderConfirmDto, Boolean excludeCost) {
        String orderCode = orderConfirmDto.getOrderCode();
        Validate.notBlank((CharSequence)orderCode, (String)"\u652f\u4ed8\u8ba2\u5355\u65f6\uff0c\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Order> orders = this.orderRepository.findDetailByOrderCodes(Lists.newArrayList((Object[])new String[]{orderCode}));
        Validate.isTrue((!CollectionUtils.isEmpty(orders) ? 1 : 0) != 0, (String)"\u652f\u4ed8\u8ba2\u5355\u65f6\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f", (Object[])new Object[0]);
        for (Order order : orders) {
            if (!excludeCost.booleanValue()) {
                this.occupyOrder(order);
            }
            this.occupyStock(order);
            this.commitProcess(orderConfirmDto, order);
        }
    }

    @Override
    @Transactional
    public void occupyStock(OrderConfirmDto orderConfirmDto) {
        String orderCode = orderConfirmDto.getOrderCode();
        Validate.notBlank((CharSequence)orderCode, (String)"\u652f\u4ed8\u8ba2\u5355\u65f6\uff0c\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Order> orders = this.orderRepository.findDetailByOrderCodes(Lists.newArrayList((Object[])new String[]{orderCode}));
        Validate.isTrue((!CollectionUtils.isEmpty(orders) ? 1 : 0) != 0, (String)"\u652f\u4ed8\u8ba2\u5355\u65f6\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f", (Object[])new Object[0]);
        for (Order order : orders) {
            this.occupyStock(order);
        }
    }

    private void occupyStock(Order order) {
        WarehouseVo warehouse = this.orderAssist.findWarehouseVo(order);
        Validate.notNull((Object)warehouse, (String)"\u8ba2\u5355\u5360\u7528\u5e93\u5b58\u7684\u65f6\u5019\uff0c\u6ca1\u6709\u627e\u5230\u4ed3\u5e93\u4fe1\u606f", (Object[])new Object[0]);
        List<ProductStockOperationDto> list = this.orderAssist.getProductStockOperationDtos(order, warehouse);
        this.productStockVoService.frozenBatch(list);
    }

    private void occupyOrder(Order order) {
        List<CostPoolReplenishmentDto> replenishmentDto;
        CostPoolDiscountDto discountDto;
        CreditPayDto creditPayDto;
        JSONArray array = new JSONArray();
        CostPoolCapitalDto costPoolCapitalDto = this.getCapitalDto(order);
        if (Objects.nonNull(costPoolCapitalDto)) {
            array.add((Object)costPoolCapitalDto);
        }
        if (Objects.nonNull(creditPayDto = this.getCreditPayDto(order))) {
            array.add((Object)creditPayDto);
        }
        if (Objects.nonNull(discountDto = this.getDiscountDto(order))) {
            array.add((Object)discountDto);
        }
        if (!CollectionUtils.isEmpty(replenishmentDto = this.getReplenishmentDto(order))) {
            array.addAll(replenishmentDto);
        }
        this.costPoolVoService.handleAdjust(array);
    }

    private List<CostPoolReplenishmentDto> getReplenishmentDto(Order order) {
        List<OrderDetail> orderDetails = order.getOrderDetails();
        if (CollectionUtils.isEmpty(orderDetails)) {
            return null;
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)orderDetails.size());
        for (OrderDetail orderDetail : orderDetails) {
            BigDecimal salesAmount = orderDetail.getSalesAmount();
            String itemType = orderDetail.getItemType();
            if (!itemType.equals(ItemTypeEnum.COMPENSATED_GOODS.getDictCode())) continue;
            CostPoolReplenishmentDto dto = OrderAssist.getCostPoolReplenishmentDto(order, orderDetail, salesAmount, com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum.OCCUPY_USE);
            list.add(dto);
        }
        return list;
    }

    private CostPoolDiscountDto getDiscountDto(Order order) {
        BigDecimal itemAmount = OrderAssist.getTallyItemAmount(order, this.discountApportionTallyItemRegister);
        if (itemAmount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return OrderAssist.getCostPoolDiscountDto(order, itemAmount, PoolOperationTypeEnum.OCCUPY_USE);
    }

    private CreditPayDto getCreditPayDto(Order order) {
        BigDecimal itemAmount = OrderAssist.getTallyItemAmount(order, this.creditTallyItemRegister);
        if (itemAmount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return OrderAssist.getCreditPayDto(order, itemAmount, CashAdjustOperateEnum.OCCUPY_USE, CashAdjustTypeEnum.OCCUPY_USE);
    }

    private CostPoolCapitalDto getCapitalDto(Order order) {
        BigDecimal itemAmount = OrderAssist.getTallyItemAmount(order, this.capitalTallyItemRegister);
        if (itemAmount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return OrderAssist.getCostPoolCapitalDto(order, itemAmount, CapitalAdjustTypeEnum.OCCUPY_USE);
    }

    private void commitProcess(OrderConfirmDto orderDto, Order order) {
        StartProcessDto start = new StartProcessDto();
        start.setProcessKey(orderDto.getProcessKey());
        start.setBusinessId(order.getId());
        start.setBusinessNo(order.getOrderCode());
        start.setRemark(orderDto.getProcessRemark());
        start.setAttachmentVos(orderDto.getAttachmentVos());
        start.setMenuCode(orderDto.getCompetenceCode());
        start.setFormType(OrderCategoryEnum.SALES_ORDER.getDictCode());
        start.setProcessTitle(StringUtils.join((Object[])new String[]{"\u8ba2\u5355\u5ba1\u6279", "\uff1a", order.getOrderCode()}));
        HashMap map = Maps.newHashMap();
        map.put("customer_code", order.getRelateCode());
        start.setVariables((Map)map);
        SerializableBiConsumer & Serializable sf = ProcessListener::onStartProcess;
        CommitWorkflowResponse response = (CommitWorkflowResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)start, ProcessListener.class, (SerializableBiConsumer)sf);
        Validate.notNull((Object)response, (String)"\u5728\u53d1\u8d77\u8ba2\u5355\u5de5\u4f5c\u6d41\u65f6\uff0c\u6ca1\u6709\u53d1\u73b0\u4e8b\u4ef6\u76d1\u542c\u5b9e\u73b0", (Object[])new Object[0]);
        if (!StringUtils.isNotEmpty((CharSequence)response.getProcessInstanceId())) {
            throw new RuntimeException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25\uff01");
        }
        this.orderRepository.updateOrderStatusAndProcessNumberById(OrderStatusEnum.AWAIT_APPROVE.getDictCode(), response.getProcessInstanceId(), order.getId());
    }
}

