/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.common.sdk.model.TallyItemRegisterModel;
import com.biz.crm.dms.business.order.common.sdk.service.TallyItemRegisterService;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderPay;
import com.biz.crm.dms.business.order.local.repository.OrderPayRepository;
import com.biz.crm.dms.business.order.local.service.OrderPayService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orderPayService")
public class OrderPayServiceImpl
implements OrderPayService {
    @Autowired(required=false)
    private OrderPayRepository orderPayRepository;
    @Autowired(required=false)
    private TallyItemRegisterService tallyItemRegisterService;

    @Override
    public Page<OrderPay> findByConditions(Pageable pageable, OrderPay orderPay) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)orderPay)) {
            orderPay = new OrderPay();
        }
        return this.orderPayRepository.findByConditions(pageable, orderPay);
    }

    @Override
    public OrderPay findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (OrderPay)((Object)this.orderPayRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public OrderPay create(OrderPay orderPay) {
        this.createValidate(orderPay);
        this.orderPayRepository.saveOrUpdate((Object)orderPay);
        return orderPay;
    }

    @Override
    @Transactional
    public OrderPay update(OrderPay orderPay) {
        this.updateValidate(orderPay);
        this.orderPayRepository.saveOrUpdate((Object)orderPay);
        return orderPay;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.orderPayRepository.removeByIds(idList);
    }

    @Override
    @Transactional
    public void createBatch(Order order) {
        Validate.notNull((Object)((Object)order), (String)"\u6279\u91cf\u6301\u4e45\u5316\u8ba2\u5355\u3010\u8bb0\u8d26\u9879\u76ee\u3011\u65f6\uff0c\u8ba2\u5355\u4e3b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean draft = order.getDraft();
        List<OrderPay> orderPays = order.getOrderPays();
        if (CollectionUtils.isEmpty(orderPays)) {
            return;
        }
        for (OrderPay orderPay : orderPays) {
            orderPay.setOrderCode(order.getOrderCode());
            orderPay.setTenantCode(order.getTenantCode());
            orderPay.setAppCode(order.getAppCode());
            this.createValidate(orderPay);
            if (draft.booleanValue()) continue;
            this.requiredValidate(orderPay);
        }
        this.orderPayRepository.saveOrUpdateBatch(orderPays);
    }

    @Override
    @Transactional
    public void deleteByOrderCode(String orderCode) {
        Validate.notBlank((CharSequence)orderCode, (String)"\u5220\u9664\u65f6\uff0c\u8981\u4f20\u5165\u8ba2\u5355\u7f16\u7801", (Object[])new Object[0]);
        this.orderPayRepository.deleteByOrderCode(orderCode);
    }

    private void requiredValidate(OrderPay orderPay) {
        Validate.notBlank((CharSequence)orderPay.getItemGroupKey(), (String)"\u9879\u76ee\u7ec4\u7684key\uff0c\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderPay.getItemKey(), (String)"\u9879\u76eekey\uff0c\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderPay.getItemName(), (String)"\u9879\u76ee\u540d\u79f0\uff0c\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)orderPay.getItemAmount(), (String)"\u9879\u76ee\u91d1\u989d\uff0c\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
    }

    private void createValidate(OrderPay orderPay) {
        Validate.notNull((Object)((Object)orderPay), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderPay.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderPay.getAppCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u54c1\u724c\u5546\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderPay.getOrderCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Boolean itemGroupType = orderPay.getItemGroupType();
        String itemGroupKey = orderPay.getItemGroupKey();
        String itemKey = orderPay.getItemKey();
        String itemName = orderPay.getItemName();
        BigDecimal itemAmount = orderPay.getItemAmount();
        Validate.notNull((Object)itemGroupType, (String)"\u9879\u76ee\u7ec4\u7c7b\u578b\uff0c\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)itemGroupKey, (String)"\u9879\u76ee\u7ec4\u7684key\uff0c\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)itemKey, (String)"\u9879\u76eekey\uff0c\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)itemName, (String)"\u9879\u76ee\u540d\u79f0\uff0c\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)itemAmount, (String)"\u9879\u76ee\u91d1\u989d\uff0c\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        List models = this.tallyItemRegisterService.findByItemGroupKey(itemGroupKey);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)models) ? 1 : 0) != 0, (String)"\u9879\u76ee\u7ec4\u7684key\uff0c\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        TallyItemRegisterModel model = this.tallyItemRegisterService.findByItemKey(itemKey);
        Validate.notNull((Object)model, (String)"\u9879\u76eekey\uff0c\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        TallyItemRegisterModel model1 = this.tallyItemRegisterService.findByItemGroupKeyAndItemKey(itemGroupKey, itemKey);
        Validate.notNull((Object)model1, (String)"\u9879\u76eekey\u4e0e\u9879\u76ee\u7ec4\u7684key\uff0c\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        boolean gtZero = itemAmount.compareTo(BigDecimal.ZERO) > -1;
        Validate.isTrue((boolean)gtZero, (String)"\u9879\u76ee\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((itemGroupKey.length() < 32 ? 1 : 0) != 0, (String)"\u9879\u76ee\u7ec4\u7684key,\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((itemKey.length() < 32 ? 1 : 0) != 0, (String)"\u9879\u76eekey,\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((itemName.length() < 32 ? 1 : 0) != 0, (String)"\u9879\u76ee\u540d\u79f0,\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(OrderPay orderPay) {
        Validate.notNull((Object)((Object)orderPay), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderPay.getId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderPay.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderPay.getAppCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u54c1\u724c\u5546\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

