/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.biz.crm.dms.business.order.apportion.sdk.model.OrderApportionContext;
import com.biz.crm.dms.business.order.apportion.sdk.service.OrderApportionVoService;
import com.biz.crm.dms.business.order.apportion.sdk.service.OrderApportionVoServiceChain;
import com.biz.crm.dms.business.order.apportion.sdk.service.OrderApportionVoServiceChainInstance;
import com.biz.crm.dms.business.order.apportion.sdk.vo.OrderApportionVo;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCommitPhaseEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.common.sdk.model.TallyItemRegisterModel;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVo;
import com.biz.crm.dms.business.order.config.sdk.service.OrderValidateVoService;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.service.OrderService;
import com.biz.crm.dms.business.order.local.service.assist.OrderAssist;
import com.biz.crm.dms.business.order.sdk.dto.OrderPayConfirmDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderPreviewDto;
import com.biz.crm.dms.business.order.sdk.service.OrderPreviewService;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailPayPreviewVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailPreviewVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderPayPreviewVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderPolicyDetailVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderPreviewVo;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.service.OrderVerificationService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrderPreviewServiceImpl
implements OrderPreviewService {
    @Autowired(required=false)
    private OrderValidateVoService orderValidateVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private OrderVerificationService orderVerificationService;
    @Autowired(required=false)
    private OrderApportionVoServiceChainInstance orderApportionVoServiceChainInstance;
    @Autowired(required=false)
    private List<OrderApportionVoService> orderApportionVoServiceList;
    @Autowired(required=false)
    private OrderAssist orderAssist;
    @Qualifier(value="CapitalTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister capitalTallyItemRegister;
    @Qualifier(value="CreditTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister creditTallyItemRegister;
    @Autowired(required=false)
    @Qualifier(value="costPoolCapitalStrategyImpl")
    private CostPoolStrategy costPoolCapitalStrategy;
    @Autowired(required=false)
    @Qualifier(value="costPoolCapitalRegisterImpl")
    private CostPoolRegister costPoolCapitalRegister;
    @Autowired(required=false)
    @Qualifier(value="CostPoolCreditStrategyImpl")
    private CostPoolStrategy costPoolCreditStrategy;
    @Autowired(required=false)
    @Qualifier(value="CostPoolCreditRegisterImpl")
    private CostPoolRegister costPoolCreditRegister;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private OrderService orderService;

    public OrderPreviewVo handlePreview(OrderPreviewDto order) {
        this.orderAssist.filterAndInitializeData(order);
        OrderConfigVo orderValidateDto = this.orderValidateVoService.findByOrderTypeAndCustomerCode(order.getOrderType(), order.getRelateCode());
        Validate.notNull((Object)orderValidateDto, (String)String.format("\u8ba2\u5355\u7c7b\u578b%s\uff0c\u5ba2\u6237\u7f16\u7801%s\uff0c\u6ca1\u6709\u8ba2\u5355\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\uff01", OrderTypeEnum.findByCode((String)order.getOrderType()).getValue(), order.getRelateCode()), (Object[])new Object[0]);
        OrderDto orderContextDto = (OrderDto)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderDto.class, HashSet.class, LinkedList.class, new String[0]);
        OrderVerificationContext orderVerificationContext = new OrderVerificationContext();
        orderVerificationContext.setOrderDto(orderContextDto);
        orderVerificationContext.setOrderConfigVo(orderValidateDto);
        orderVerificationContext.setProcessNodeEnum(OrderValidationProcessNodeEnum.ONE);
        this.orderVerificationService.execute(orderVerificationContext);
        OrderApportionContext context = new OrderApportionContext();
        context.setOrderConfigVo(orderValidateDto);
        context.setOrderDto(orderContextDto);
        context.setOrderCommitPhaseEnum(OrderCommitPhaseEnum.PREVIEW);
        Validate.isTrue((!CollectionUtils.isEmpty(this.orderApportionVoServiceList) ? 1 : 0) != 0, (String)"\u8fd8\u6ca1\u6709\u5206\u644a\u5b9e\u73b0\uff0c\u8bf7\u786e\u8ba4\u9879\u76ee\u662f\u5426\u6b63\u786e\u6784\u5efa", (Object[])new Object[0]);
        Collections.sort(this.orderApportionVoServiceList);
        OrderApportionVoServiceChain chain = this.orderApportionVoServiceChainInstance.getChain(this.orderApportionVoServiceList);
        chain.execute(context);
        OrderApportionVo orderApportionVo = context.getOrderApportionVo();
        OrderPreviewVo orderPreviewVo = (OrderPreviewVo)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderPreviewVo.class, HashSet.class, LinkedList.class, new String[0]);
        OrderPreviewVo apportionOrderPreviewVo = (OrderPreviewVo)this.nebulaToolkitService.copyObjectByBlankList((Object)orderApportionVo, OrderPreviewVo.class, HashSet.class, LinkedList.class, new String[0]);
        List inputOrderDetails = orderPreviewVo.getOrderDetails();
        List orderDetails = apportionOrderPreviewVo.getOrderDetails();
        List<OrderDetailPreviewVo> unionSet = OrderAssist.unionOrderDetails(inputOrderDetails, orderDetails);
        orderPreviewVo.setOrderDetails(unionSet);
        this.tabulateData(orderPreviewVo);
        this.setOrderPays(orderPreviewVo, order);
        this.findSkuMedia(orderPreviewVo);
        return orderPreviewVo;
    }

    private void setOrderPays(OrderPreviewVo order, OrderPreviewDto orderConfirmDto) {
        BigDecimal totalUsableAmount;
        int compare;
        List orderPays = order.getOrderPays();
        if (CollectionUtils.isEmpty((Collection)orderPays)) {
            orderPays = Lists.newLinkedList();
            order.setOrderPays(orderPays);
        }
        Iterator iterator = orderPays.iterator();
        while (iterator.hasNext()) {
            OrderPayPreviewVo next = (OrderPayPreviewVo)iterator.next();
            Boolean itemGroupType = next.getItemGroupType();
            if (!itemGroupType.booleanValue()) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty((Collection)orderConfirmDto.getRefundOrderPays())) {
            return;
        }
        String orderType = order.getOrderType();
        boolean isFree = OrderTypeEnum.FREE.getDictCode().equals(orderType);
        if (isFree) {
            return;
        }
        TallyItemRegisterModel capitalTallyItem = this.capitalTallyItemRegister.findTallyItemRegisterModel();
        OrderPayPreviewVo capital = new OrderPayPreviewVo();
        Boolean pay = this.isPay(capitalTallyItem);
        capital.setItemGroupType(pay);
        capital.setItemGroupKey(capitalTallyItem.getItemGroupKey());
        capital.setItemKey(capitalTallyItem.getItemKey());
        capital.setItemName(capitalTallyItem.getItemName());
        orderPays.add(capital);
        TallyItemRegisterModel creditTallyItem = this.creditTallyItemRegister.findTallyItemRegisterModel();
        OrderPayPreviewVo credit = new OrderPayPreviewVo();
        Boolean isPay = this.isPay(creditTallyItem);
        credit.setItemGroupType(isPay);
        credit.setItemGroupKey(creditTallyItem.getItemGroupKey());
        credit.setItemKey(creditTallyItem.getItemKey());
        credit.setItemName(creditTallyItem.getItemName());
        orderPays.add(credit);
        BigDecimal actualAmountPaid = order.getActualAmountPaid();
        BigDecimal capitalUsableAmount = this.findUsableAmount(this.costPoolCapitalRegister, order.getRelateCode(), this.costPoolCapitalStrategy);
        BigDecimal creditUsableAmount = this.findUsableAmount(this.costPoolCreditRegister, order.getRelateCode(), this.costPoolCreditStrategy);
        List refundOrderPays = orderConfirmDto.getRefundOrderPays();
        if (!CollectionUtils.isEmpty((Collection)refundOrderPays)) {
            for (OrderPayConfirmDto refundOrderPay : refundOrderPays) {
                boolean isCredit;
                BigDecimal itemAmount = refundOrderPay.getItemAmount();
                Boolean itemGroupType = refundOrderPay.getItemGroupType();
                if (itemGroupType == null && !itemGroupType.booleanValue()) continue;
                boolean isCapital = capitalTallyItem.getItemKey().equals(refundOrderPay.getItemKey());
                if (isCapital) {
                    capitalUsableAmount = capitalUsableAmount.add(itemAmount);
                }
                if (!(isCredit = creditTallyItem.getItemKey().equals(refundOrderPay.getItemKey()))) continue;
                creditUsableAmount = creditUsableAmount.add(itemAmount);
            }
        }
        if ((compare = actualAmountPaid.compareTo(totalUsableAmount = capitalUsableAmount.add(creditUsableAmount))) > 0) {
            throw new IllegalArgumentException("\u4f59\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u652f\u4ed8\u8ba2\u5355");
        }
        if (compare < 0) {
            int compareCapital = actualAmountPaid.compareTo(capitalUsableAmount);
            if (compareCapital > 0) {
                capital.setItemAmount(capitalUsableAmount);
                credit.setItemAmount(actualAmountPaid.subtract(capitalUsableAmount));
            } else if (compareCapital < 0) {
                capital.setItemAmount(actualAmountPaid);
                credit.setItemAmount(BigDecimal.ZERO);
            } else {
                capital.setItemAmount(actualAmountPaid);
                credit.setItemAmount(BigDecimal.ZERO);
            }
        } else {
            capital.setItemAmount(capitalUsableAmount);
            credit.setItemAmount(creditUsableAmount);
        }
    }

    private Boolean isPay(TallyItemRegisterModel creditTallyItem) {
        Integer itemGroupTypeInt = Integer.valueOf(creditTallyItem.getTallyItemGroupType().getDictCode());
        Boolean isPay = itemGroupTypeInt != 0;
        return isPay;
    }

    private BigDecimal findUsableAmount(CostPoolRegister costPoolRegister, String customerCode, CostPoolStrategy costPoolStrategy) {
        CostPoolDto costPoolDto = new CostPoolDto();
        costPoolDto.setPoolType(costPoolRegister.getKey());
        costPoolDto.setCustomerCode(customerCode);
        List costPoolVos = costPoolStrategy.onRequestCostPoolVos(costPoolDto);
        if (CollectionUtils.isEmpty((Collection)costPoolVos)) {
            return BigDecimal.ZERO;
        }
        BigDecimal usableAmount = costPoolVos.stream().map(CostPoolVo::getUsableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return usableAmount;
    }

    private void findSkuMedia(OrderPreviewVo orderPreviewVo) {
        List orderDetails = orderPreviewVo.getOrderDetails();
        List productCodeList = orderDetails.stream().map(OrderDetailPreviewVo::getGoodsCode).collect(Collectors.toList());
        List productList = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodeList);
        HashMap<String, ProductVo> productCodeMap = new HashMap<String, ProductVo>(productList.size());
        for (ProductVo productVo : productList) {
            productCodeMap.put(productVo.getProductCode(), productVo);
        }
        for (OrderDetailPreviewVo orderDetail : orderDetails) {
            String goodsCode = orderDetail.getGoodsCode();
            ProductVo productVo = (ProductVo)productCodeMap.get(goodsCode);
            if (ObjectUtils.isEmpty((Object)productVo)) continue;
            List<FileVo> pictureFileList = OrderAssist.getFileVos(productVo.getPictureMediaList());
            List<FileVo> videoFileList = OrderAssist.getFileVos(productVo.getVideoMediaList());
            orderDetail.setPictureMediaList(pictureFileList);
            orderDetail.setVideoMediaList(videoFileList);
        }
    }

    public OrderPreviewVo handlePreviewByCurrentCustomer(OrderPreviewDto order) {
        LoginUserDetailsForEMS loginDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        order.setRelateCode(loginDetails.getCustomerCode());
        order.setRelateName(loginDetails.getCustomerName());
        OrderPreviewVo orderPreviewVo = this.handlePreview(order);
        return orderPreviewVo;
    }

    public OrderPreviewVo handlePreviewByOrderId(String orderId) {
        Validate.notBlank((CharSequence)orderId, (String)"\u8ba2\u5355ID\u5fc5\u987b\u4f20", (Object[])new Object[0]);
        Order order = this.orderService.findById(orderId);
        OrderPreviewDto orderPreviewDto = (OrderPreviewDto)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderPreviewDto.class, HashSet.class, LinkedList.class, new String[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)orderPreviewDto.getOrderDetails()) ? 1 : 0) != 0, (String)"\u8be5\u8ba2\u5355\u4e0d\u542b\u5546\u54c1\u4e0d\u80fd\u518d\u6765\u4e00\u5355", (Object[])new Object[0]);
        orderPreviewDto.getOrderDetails().forEach(item -> item.setIsAutoHit(Boolean.valueOf(true)));
        return this.handlePreview(orderPreviewDto);
    }

    private void tabulateData(OrderPreviewVo orderPreviewVo) {
        List orderDetails;
        BigDecimal totalOrderAmount = BigDecimal.ZERO;
        BigDecimal policyDiscountAmount = BigDecimal.ZERO;
        BigDecimal totalCompensatedAmount = BigDecimal.ZERO;
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        List orderPays = orderPreviewVo.getOrderPays();
        if (!CollectionUtils.isEmpty((Collection)orderPays)) {
            for (OrderPayPreviewVo orderPay : orderPays) {
                Boolean itemGroupType = orderPay.getItemGroupType();
                if (itemGroupType.booleanValue()) continue;
                BigDecimal itemAmount = orderPay.getItemAmount();
                itemAmount = Objects.nonNull(itemAmount) ? itemAmount : BigDecimal.ZERO;
                totalDiscountAmount = totalDiscountAmount.add(itemAmount);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(orderDetails = orderPreviewVo.getOrderDetails()))) {
            HashMap<String, OrderPolicyDetailVo> policyDetailMap = new HashMap<String, OrderPolicyDetailVo>(orderDetails.size());
            for (OrderDetailPreviewVo orderDetail : orderDetails) {
                String itemType;
                BigDecimal salesAmount = orderDetail.getSalesAmount();
                BigDecimal totalItemAmount = BigDecimal.ZERO;
                BigDecimal totalPolicyItemAmount = BigDecimal.ZERO;
                List orderDetailPays = orderDetail.getOrderDetailPays();
                if (!CollectionUtils.isEmpty((Collection)orderDetailPays)) {
                    for (OrderDetailPayPreviewVo orderDetailPay : orderDetailPays) {
                        List goodsName;
                        Boolean available = orderDetailPay.getAvailable();
                        if (ObjectUtils.isEmpty((Object)available)) continue;
                        if (available.booleanValue()) {
                            BigDecimal itemAmount = orderDetailPay.getItemAmount();
                            totalItemAmount = totalItemAmount.add(itemAmount);
                            String itemGroupKey = "salepolicyGroup";
                            boolean equals = itemGroupKey.equals(orderDetailPay.getItemGroupKey());
                            if (equals) {
                                totalPolicyItemAmount = totalPolicyItemAmount.add(itemAmount);
                            }
                        }
                        String originData = orderDetailPay.getOriginData();
                        String originDataAlias = orderDetailPay.getOriginDataAlias();
                        OrderPolicyDetailVo orderPolicyDetailVo = (OrderPolicyDetailVo)policyDetailMap.get(originData);
                        if (Objects.isNull(orderPolicyDetailVo)) {
                            orderPolicyDetailVo = new OrderPolicyDetailVo();
                            policyDetailMap.put(originData, orderPolicyDetailVo);
                            orderPolicyDetailVo.setOriginDataAlias(originDataAlias);
                        }
                        String itemType2 = orderDetail.getItemType();
                        if (ItemTypeEnum.NORMAL_GOODS.getDictCode().equals(itemType2)) {
                            goodsName = orderPolicyDetailVo.getGoodsName();
                            goodsName.add(orderDetail.getGoodsName());
                        }
                        if (ItemTypeEnum.COMPLIMENTARY_GOODS.getDictCode().equals(itemType2)) {
                            goodsName = orderPolicyDetailVo.getComplimentaryGoodsName();
                            goodsName.add(orderDetail.getGoodsName());
                        }
                        List reason = orderPolicyDetailVo.getReason();
                        reason.add(orderDetailPay.getReason());
                        BigDecimal policyAmount = orderPolicyDetailVo.getItemAmount();
                        policyAmount = policyAmount.add(orderDetailPay.getItemAmount());
                        orderPolicyDetailVo.setItemAmount(policyAmount);
                    }
                }
                BigDecimal shouldPaymentAmount = salesAmount.subtract(totalItemAmount);
                orderDetail.setShouldPaymentAmount(shouldPaymentAmount);
                policyDiscountAmount = policyDiscountAmount.add(totalPolicyItemAmount);
                totalOrderAmount = totalOrderAmount.add(salesAmount);
                if (!CollectionUtils.isEmpty(policyDetailMap)) {
                    LinkedList orderPolicyDetailList = Lists.newLinkedList();
                    for (Map.Entry entry : policyDetailMap.entrySet()) {
                        orderPolicyDetailList.add((OrderPolicyDetailVo)entry.getValue());
                    }
                    orderPreviewVo.setOrderPolicyDetail((List)orderPolicyDetailList);
                }
                if (!(itemType = orderDetail.getItemType()).equals(ItemTypeEnum.COMPENSATED_GOODS.getDictCode())) continue;
                totalCompensatedAmount = totalCompensatedAmount.add(salesAmount);
            }
        }
        orderPreviewVo.setTotalOrderAmount(totalOrderAmount);
        BigDecimal actualAmountPaid = totalOrderAmount.subtract(policyDiscountAmount).subtract(totalCompensatedAmount).subtract(totalDiscountAmount);
        String orderType = orderPreviewVo.getOrderType();
        boolean isFree = OrderTypeEnum.FREE.getDictCode().equals(orderType);
        orderPreviewVo.setActualAmountPaid(isFree ? BigDecimal.ZERO : actualAmountPaid);
        orderPreviewVo.setPolicyDiscountAmount(policyDiscountAmount);
    }
}

