/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderDetail;
import com.biz.crm.dms.business.order.local.repository.OrderRepository;
import com.biz.crm.dms.business.order.local.service.OrderDetailService;
import com.biz.crm.dms.business.order.local.service.OrderFileService;
import com.biz.crm.dms.business.order.local.service.OrderPayService;
import com.biz.crm.dms.business.order.local.service.OrderService;
import com.biz.crm.dms.business.order.sdk.dto.CustomerOrderPageDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderEventDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderPaginationDto;
import com.biz.crm.dms.business.order.sdk.event.OrderLogEventListener;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orderService")
public class OrderServiceImpl
implements OrderService {
    @Autowired(required=false)
    private OrderRepository orderRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private OrderPayService orderPayService;
    @Autowired(required=false)
    private OrderFileService orderFileService;
    @Autowired(required=false)
    private OrderDetailService orderDetailService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public Page<Order> findByConditions(Pageable pageable, OrderPaginationDto order) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(order)) {
            order = new OrderPaginationDto();
        }
        order.setTenantCode(TenantUtils.getTenantCode());
        order.setAppCode(TenantUtils.getAppCode());
        order.setIsShow(Boolean.valueOf(true));
        return this.orderRepository.findByConditions(pageable, order);
    }

    @Override
    public Order findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.orderRepository.findDetailById(id);
    }

    @Override
    @Transactional
    public Order create(Order order) {
        this.paddingData(order);
        Boolean draft = order.getDraft();
        Validate.notNull((Object)draft, (String)"\u6682\u5b58\u6807\u8bc6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (draft.booleanValue()) {
            order.setOrderStatus(OrderStatusEnum.STAGING.getDictCode());
            this.draftValidate(order);
            Order orderDb = this.findByOrderCode(order.getOrderCode());
            if (orderDb != null) {
                order.setId(orderDb.getId());
            }
            this.deleteDraftByOrderCode(order.getOrderCode());
            this.tabulateData(order);
        } else {
            this.submitValidate(order);
        }
        this.orderRepository.saveOrUpdate((Object)order);
        this.saveDetails(order);
        OrderEventDto orderEventDto = new OrderEventDto();
        orderEventDto.setOriginal(null);
        OrderVo orderVo = (OrderVo)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderVo.class, HashSet.class, LinkedList.class, new String[0]);
        orderEventDto.setNewest(orderVo);
        SerializableBiConsumer & Serializable onCreate = OrderLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)orderEventDto, OrderLogEventListener.class, (SerializableBiConsumer)onCreate);
        return order;
    }

    private void tabulateData(Order order) {
        BigDecimal totalCountGoods = BigDecimal.ZERO;
        BigDecimal totalOrderAmount = BigDecimal.ZERO;
        List<OrderDetail> orderDetails = order.getOrderDetails();
        if (CollectionUtils.isEmpty(orderDetails)) {
            return;
        }
        for (OrderDetail orderDetail : orderDetails) {
            BigDecimal salesAmount = orderDetail.getSalesAmount();
            totalOrderAmount = totalOrderAmount.add(salesAmount);
            BigDecimal quantity = orderDetail.getQuantity();
            if (ObjectUtils.isEmpty((Object)quantity)) continue;
            totalCountGoods = totalCountGoods.add(quantity);
        }
        order.setQuantityOfCommodity(totalCountGoods);
        order.setTotalOrderAmount(totalOrderAmount);
    }

    private void saveDetails(Order order) {
        this.orderFileService.createBatch(order);
        this.orderPayService.createBatch(order);
        this.orderDetailService.createBatch(order);
    }

    private void submitValidate(Order order) {
    }

    private void draftValidate(Order order) {
        Validate.notNull((Object)((Object)order), (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = order.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)"\u79df\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String orderCode = order.getOrderCode();
        Validate.notBlank((CharSequence)orderCode, (String)"\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void paddingData(Order order) {
        String appCode = TenantUtils.getAppCode();
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notBlank((CharSequence)appCode, (String)"\u5f53\u524d\u767b\u5f55\u8d26\u6237\u6ca1\u6709appCode\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)"\u5f53\u524d\u767b\u5f55\u8d26\u6237\u6ca1\u6709tenantCode\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (Object[])new Object[0]);
        order.setAppCode(appCode);
        order.setTenantCode(tenantCode);
        if (StringUtils.isBlank((CharSequence)order.getOrderCode())) {
            String ruleCode = StringUtils.join((Object[])new String[]{"OD", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
            String orderCode = (String)this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            order.setOrderCode(orderCode);
        }
        String externalSources = order.getExternalSources();
        Boolean isShow = order.getIsShow();
        if (isShow == null) {
            order.setIsShow(true);
        }
        if (StringUtils.isBlank((CharSequence)externalSources)) {
            order.setIsShow(true);
        }
    }

    @Override
    @Transactional
    public Order update(Order order) {
        order.setTenantCode(TenantUtils.getTenantCode());
        this.updateValidate(order);
        this.orderRepository.saveOrUpdate((Object)order);
        return order;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List orders = this.orderRepository.listByIds(idList);
        HashSet set = Sets.newHashSet((Object[])new String[]{OrderStatusEnum.STAGING.getDictCode(), OrderStatusEnum.REJECTED.getDictCode(), OrderStatusEnum.CANCELED.getDictCode()});
        for (Order order : orders) {
            boolean contains = set.contains(order.getOrderStatus());
            Validate.isTrue((boolean)contains, (String)"\u542b\u6709\u4e0d\u80fd\u5220\u9664\u7684\u8ba2\u5355\u72b6\u6001", (Object[])new Object[0]);
            this.deleteDraftByOrderCode(order.getOrderCode());
            this.orderRepository.removeById((Serializable)((Object)order.getId()));
        }
    }

    @Override
    public Order findByOrderCode(String orderCode) {
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            return null;
        }
        return this.orderRepository.findByOrderCode(orderCode);
    }

    @Override
    @Transactional
    public void deleteDraftByOrderCode(String orderCode) {
        Validate.notBlank((CharSequence)orderCode, (String)"\u5220\u9664\u4fe1\u606f\u65f6\uff0c\u8981\u4f20\u5165\u8ba2\u5355\u7f16\u7801", (Object[])new Object[0]);
        this.orderDetailService.deleteByOrderCode(orderCode);
        this.orderPayService.deleteByOrderCode(orderCode);
        this.orderFileService.deleteByOrderCode(orderCode);
    }

    @Override
    public Page<Order> findByCustomerOrderPageDto(Pageable pageable, CustomerOrderPageDto customerOrderPageDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(customerOrderPageDto)) {
            customerOrderPageDto = new CustomerOrderPageDto();
        }
        LoginUserDetailsForEMS loginDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        customerOrderPageDto.setRelateCode(loginDetails.getCustomerCode());
        customerOrderPageDto.setAppCode(TenantUtils.getAppCode());
        Page<Order> page = this.orderRepository.findByCustomerOrderPageDto(pageable, customerOrderPageDto);
        List records = page.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List<String> orderCodes = records.stream().map(Order::getOrderCode).collect(Collectors.toList());
            List<Order> orders = this.orderRepository.findDetailByOrderCodes(orderCodes);
            HashMap<String, Order> orderCodeToOrderMap = new HashMap<String, Order>(orders.size());
            for (Order order : orders) {
                orderCodeToOrderMap.put(order.getOrderCode(), order);
            }
            for (Order record : records) {
                String orderCode = record.getOrderCode();
                Order orderDb = (Order)((Object)orderCodeToOrderMap.get(orderCode));
                record.setOrderDetails(orderDb.getOrderDetails());
                record.setOrderPays(orderDb.getOrderPays());
            }
        }
        return page;
    }

    @Override
    public List<Order> findRefundableByCustomerCode(String relateCode) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)relateCode), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{OrderStatusEnum.PART_SHIPPED.getDictCode(), OrderStatusEnum.COMPLETED.getDictCode()});
        return this.orderRepository.findByRelateCodeAndOrderStatusIn(relateCode, orderStatusList);
    }

    private void updateValidate(Order order) {
        Validate.notNull((Object)((Object)order), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        order.setTenantCode(TenantUtils.getTenantCode());
        order.setAppCode(TenantUtils.getAppCode());
        Validate.notBlank((CharSequence)order.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)order.getTenantCode(), (String)"\u4fee\u6539\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)order.getAppCode(), (String)"\u4fee\u6539\u65f6\uff0c\u54c1\u724c\u5546\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

