/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.repository.OrderRepository;
import com.biz.crm.dms.business.order.sdk.service.OrderStatusStatisticsVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderStatusStatisticsVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrderStatusStatisticsVoServiceImpl
implements OrderStatusStatisticsVoService {
    @Autowired(required=false)
    private OrderRepository orderRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public List<OrderStatusStatisticsVo> findByCurrentCustomer() {
        ArrayList orderStatusStatisticsVoList = Lists.newArrayList();
        LoginUserDetailsForEMS loginDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        String customerCode = loginDetails.getCustomerCode();
        String customerName = loginDetails.getCustomerName();
        ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{OrderStatusEnum.STAGING.getDictCode(), OrderStatusEnum.WAIT_SHIPPED.getDictCode(), OrderStatusEnum.PART_SHIPPED.getDictCode(), OrderStatusEnum.REJECTED.getDictCode()});
        orderStatusList.forEach(o -> {
            OrderStatusStatisticsVo orderStatusStatisticsVo = new OrderStatusStatisticsVo();
            orderStatusStatisticsVo.setOrderStatus(o);
            orderStatusStatisticsVo.setOrderStatusDesc(OrderStatusEnum.findByCode((String)o).getValue());
            orderStatusStatisticsVo.setOrderCount(Integer.valueOf(0));
            orderStatusStatisticsVoList.add(orderStatusStatisticsVo);
        });
        List<Order> list = this.orderRepository.findByRelateCodeAndOrderStatusIn(customerCode, orderStatusList);
        Map<String, List<Order>> orderStatusMap = list.stream().collect(Collectors.groupingBy(Order::getOrderStatus));
        orderStatusStatisticsVoList.forEach(o -> {
            List orders = (List)orderStatusMap.get(o.getOrderStatus());
            o.setRelateCode(customerCode);
            o.setRelateName(customerName);
            if (!CollectionUtils.isEmpty((Collection)orders)) {
                o.setOrderCount(Integer.valueOf(orders.size()));
            }
        });
        return orderStatusStatisticsVoList;
    }
}

