/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.repository.OrderRepository;
import com.biz.crm.dms.business.order.local.service.OrderService;
import com.biz.crm.dms.business.order.local.service.assist.OrderAssist;
import com.biz.crm.dms.business.order.sdk.dto.CustomerOrderPageDto;
import com.biz.crm.dms.business.order.sdk.service.OrderVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrderVoServiceImpl
implements OrderVoService {
    @Autowired(required=false)
    private OrderRepository orderRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private OrderService orderService;
    @Autowired(required=false)
    private ProductStockVoService productStockVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public List<OrderVo> findByOrderCodes(List<String> orderCodes) {
        List<Order> detailByOrderCodes = this.orderRepository.findDetailByOrderCodes(orderCodes);
        List orderVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(detailByOrderCodes, Order.class, OrderVo.class, HashSet.class, LinkedList.class, new String[0]);
        return orderVos;
    }

    @Transactional
    public OrderVo updateOrderStatusByDeliveryQuantity(String orderCode, BigDecimal deliveryQuantity, Boolean isAdd) {
        Validate.notBlank((CharSequence)orderCode, (String)"\u6839\u636e\u53d1\u8d27\u6570\u91cf\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u65f6\uff0c\u6ca1\u6709\u4f20\u5165\u8ba2\u5355\u7f16\u7801", (Object[])new Object[0]);
        Validate.notNull((Object)isAdd, (String)"\u6839\u636e\u53d1\u8d27\u6570\u91cf\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u65f6\uff0c\u4e1a\u52a1\u6807\u8bc6\u6ca1\u4f20", (Object[])new Object[0]);
        Boolean isPositive = Objects.nonNull(deliveryQuantity) && deliveryQuantity.compareTo(BigDecimal.ZERO) == 1;
        Validate.isTrue((boolean)isPositive, (String)"\u6839\u636e\u53d1\u8d27\u6570\u91cf\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u65f6\uff0c\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e0d\u4f20\uff0c\u4e0d\u80fd\u4e3a0\uff0c\u4e3a\u8d1f\u6570", (Object[])new Object[0]);
        Order order = this.orderRepository.findByOrderCode(orderCode);
        Validate.notNull((Object)((Object)order), (String)"\u6839\u636e\u53d1\u8d27\u6570\u91cf\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u65f6\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f", (Object[])new Object[0]);
        BigDecimal deliveryQuantityDb = order.getDeliveryQuantity();
        deliveryQuantityDb = Objects.isNull(deliveryQuantityDb) ? BigDecimal.ZERO : deliveryQuantityDb;
        deliveryQuantity = isAdd != false ? deliveryQuantityDb.add(deliveryQuantity) : deliveryQuantityDb.subtract(deliveryQuantity);
        int compareToZero = deliveryQuantity.compareTo(BigDecimal.ZERO);
        Validate.isTrue((compareToZero > -1 ? 1 : 0) != 0, (String)"\u6839\u636e\u53d1\u8d27\u6570\u91cf\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u65f6\uff0c\u5df2\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f", (Object[])new Object[0]);
        if (compareToZero == 0) {
            this.orderRepository.updateOrderStatusAndDeliveryQuantityById(OrderStatusEnum.WAIT_SHIPPED.getDictCode(), deliveryQuantity, order.getId());
        } else {
            int compareToQuantity = deliveryQuantity.compareTo(order.getQuantityOfCommodity());
            Validate.isTrue((compareToQuantity <= 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u53d1\u8d27\u6570\u91cf\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u65f6\uff0c\u5df2\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u8ba2\u5355\u5546\u54c1\u603b\u91cf", (Object[])new Object[0]);
            if (compareToQuantity == 0) {
                this.orderRepository.updateOrderStatusAndDeliveryQuantityById(OrderStatusEnum.COMPLETED.getDictCode(), deliveryQuantity, order.getId());
            } else {
                this.orderRepository.updateOrderStatusAndDeliveryQuantityById(OrderStatusEnum.PART_SHIPPED.getDictCode(), deliveryQuantity, order.getId());
            }
        }
        return (OrderVo)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    public Page<OrderVo> findByCustomerOrderPageDto(Pageable pageable, CustomerOrderPageDto customerOrderPageDto) {
        Page<Order> page = this.orderService.findByCustomerOrderPageDto(pageable, customerOrderPageDto);
        Page voPage = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = page.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            voPage.setRecords((List)Lists.newArrayList());
        } else {
            List orderVos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)records, Order.class, OrderVo.class, HashSet.class, LinkedList.class, new String[0]);
            voPage.setRecords(orderVos);
        }
        return voPage;
    }

    public OrderVo findById(String id) {
        List orderDetails;
        Order order = this.orderService.findById(id);
        OrderVo orderVo = (OrderVo)this.nebulaToolkitService.copyObjectByBlankList((Object)order, OrderVo.class, HashSet.class, LinkedList.class, new String[0]);
        String orderCategory = orderVo.getOrderCategory();
        boolean isMaterial = OrderCategoryEnum.MATERIAL_ORDER.getDictCode().equals(orderCategory);
        if (isMaterial) {
            String warehouseCode = orderVo.getWarehouseCode();
            List orderDetails2 = orderVo.getOrderDetails();
            Set goodsCodes = orderDetails2.stream().map(OrderDetailVo::getGoodsCode).collect(Collectors.toSet());
            List productStockVos = this.productStockVoService.findByWarehouseAndProducts(warehouseCode, goodsCodes);
            HashMap<String, BigDecimal> skuToAvailableMap = new HashMap<String, BigDecimal>(productStockVos.size());
            for (ProductStockVo stockVo : productStockVos) {
                skuToAvailableMap.put(stockVo.getProductCode(), stockVo.getAvailableStock());
            }
            for (OrderDetailVo orderDetail : orderDetails2) {
                orderDetail.setAvailableStock((BigDecimal)skuToAvailableMap.get(orderDetail.getGoodsCode()));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(orderDetails = orderVo.getOrderDetails()))) {
            List productCodeList = orderDetails.stream().map(OrderDetailVo::getGoodsCode).collect(Collectors.toList());
            List productList = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodeList);
            HashMap<String, ProductVo> productCodeMap = new HashMap<String, ProductVo>(productList.size());
            for (ProductVo productVo : productList) {
                productCodeMap.put(productVo.getProductCode(), productVo);
            }
            for (OrderDetailVo orderDetail : orderDetails) {
                String goodsCode = orderDetail.getGoodsCode();
                ProductVo productVo = (ProductVo)productCodeMap.get(goodsCode);
                if (ObjectUtils.isEmpty((Object)productVo)) continue;
                List<FileVo> pictureFileList = OrderAssist.getFileVos(productVo.getPictureMediaList());
                List<FileVo> videoFileList = OrderAssist.getFileVos(productVo.getVideoMediaList());
                orderDetail.setPictureMediaList(pictureFileList);
                orderDetail.setVideoMediaList(videoFileList);
            }
        }
        return orderVo;
    }

    public void updateOrderStatusAndIsShowByOrderCode(String orderCode, OrderStatusEnum orderStatusEnum, Boolean isShow) {
        Order order = this.orderRepository.findByOrderCode(orderCode);
        Validate.notNull((Object)((Object)order), (String)"\u8ba2\u5355\u4fe1\u606f\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet((Object[])new String[]{OrderStatusEnum.REJECTED.getDictCode(), OrderStatusEnum.CLOSE.getDictCode(), OrderStatusEnum.CANCELED.getDictCode(), OrderStatusEnum.COMPLETED.getDictCode()});
        Validate.isTrue((!set.contains(order.getOrderStatus()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539", (Object[])new Object[0]);
        this.orderRepository.updateOrderStatusAndIsShowById(orderStatusEnum.getDictCode(), order.getId(), isShow);
    }
}

