/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.order.local.entity.HistoryViewQueryConfig;
import com.biz.crm.dms.business.order.local.entity.PurchaseHistory;
import com.biz.crm.dms.business.order.local.repository.PurchaseHistoryRepository;
import com.biz.crm.dms.business.order.local.service.HistoryViewQueryConfigService;
import com.biz.crm.dms.business.order.local.service.PurchaseHistoryService;
import com.biz.crm.dms.business.order.sdk.constant.PurchaseHistoryConstant;
import com.biz.crm.dms.business.order.sdk.dto.PurchaseHistoryPageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="purchaseHistoryService")
public class PurchaseHistoryServiceImpl
implements PurchaseHistoryService {
    @Autowired(required=false)
    private PurchaseHistoryRepository purchaseHistoryRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private HistoryViewQueryConfigService historyViewQueryConfigService;

    @Override
    public Page<PurchaseHistory> findByConditions(Pageable pageable, PurchaseHistoryPageDto purchaseHistory) {
        HistoryViewQueryConfig config;
        LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(purchaseHistory)) {
            purchaseHistory = new PurchaseHistoryPageDto();
        }
        purchaseHistory.setTimes(ObjectUtils.isNotEmpty((Object)((Object)(config = this.historyViewQueryConfigService.findByCurrentCustomerCode()))) ? config.getTimes() : PurchaseHistoryConstant.defaultTimes);
        purchaseHistory.setRelateCode(loginUserDetails.getCustomerCode());
        purchaseHistory.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        purchaseHistory.setAppCode(TenantUtils.getAppCode());
        purchaseHistory.setIsUsable(BooleanEnum.TRUE.getCapital());
        return this.purchaseHistoryRepository.findByConditions(pageable, purchaseHistory);
    }

    @Override
    public PurchaseHistory findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (PurchaseHistory)((Object)this.purchaseHistoryRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public PurchaseHistory create(PurchaseHistory purchaseHistory) {
        this.createValidate(purchaseHistory);
        this.purchaseHistoryRepository.saveOrUpdate((Object)purchaseHistory);
        return purchaseHistory;
    }

    @Override
    @Transactional
    public PurchaseHistory update(PurchaseHistory purchaseHistory) {
        this.updateValidate(purchaseHistory);
        this.purchaseHistoryRepository.saveOrUpdate((Object)purchaseHistory);
        return purchaseHistory;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.purchaseHistoryRepository.deleteByIdIn(idList);
    }

    @Override
    public List<PurchaseHistory> findByGoodsCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.purchaseHistoryRepository.findByGoodsCode(code);
    }

    @Override
    public void updateUsableStatus(String goodsCode, String isUsable) {
        Validate.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{goodsCode, isUsable}), (String)"\u7f3a\u5931\u5546\u54c1\u7f16\u7801\u4e0e\u72b6\u6001", (Object[])new Object[0]);
        this.purchaseHistoryRepository.updateUsableStatus(goodsCode, isUsable);
    }

    @Override
    @Transactional
    public List<PurchaseHistory> handleIncrement(List<PurchaseHistory> purchaseHistory) {
        Validate.isTrue((!CollectionUtils.isEmpty(purchaseHistory) ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u5546\u54c1\u8d2d\u4e70\u8bb0\u5f55\u65f6\uff0c\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList goodsCodes = Lists.newArrayListWithCapacity((int)purchaseHistory.size());
        for (PurchaseHistory history : purchaseHistory) {
            goodsCodes.add(history.getGoodsCode());
        }
        String relateCode = purchaseHistory.get(0).getRelateCode();
        List<PurchaseHistory> dbList = this.purchaseHistoryRepository.findByGoodsCodeInAndRelateCode(goodsCodes, relateCode);
        if (CollectionUtils.isEmpty(dbList)) {
            HashSet purchaseHistorySet = Sets.newHashSet(purchaseHistory);
            for (PurchaseHistory history : purchaseHistorySet) {
                this.createValidate(history);
            }
            this.purchaseHistoryRepository.saveBatch(purchaseHistorySet);
            return purchaseHistory;
        }
        HashSet purchaseHistorySet = Sets.newHashSet(purchaseHistory);
        List newList = (List)org.apache.commons.collections.CollectionUtils.subtract((Collection)purchaseHistorySet, dbList);
        if (!CollectionUtils.isEmpty((Collection)newList)) {
            for (PurchaseHistory history : newList) {
                this.createValidate(history);
            }
            this.purchaseHistoryRepository.saveBatch(newList);
        }
        List<String> ids = dbList.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.purchaseHistoryRepository.updateTimesIncrementByIdIn(ids);
        return this.purchaseHistoryRepository.findByGoodsCodeInAndRelateCode(goodsCodes, relateCode);
    }

    @Override
    public void updateByProductCode(PurchaseHistory purchaseHistory) {
        Validate.notNull((Object)((Object)purchaseHistory), (String)"\u66f4\u65b0\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)purchaseHistory.getGoodsCode(), (String)"\u65b0\u589e\u65f6\uff0c\u8d27\u7269\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.purchaseHistoryRepository.updateByProductCode(purchaseHistory);
    }

    private void createValidate(PurchaseHistory purchaseHistory) {
        Validate.notNull((Object)((Object)purchaseHistory), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        purchaseHistory.setId(null);
        purchaseHistory.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)purchaseHistory.getGoodsCode(), (String)"\u65b0\u589e\u65f6\uff0c\u8d27\u7269\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)purchaseHistory.getGoodsName(), (String)"\u65b0\u589e\u65f6\uff0c\u8d27\u7269\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)purchaseHistory.getRelateCode(), (String)"\u65b0\u589e\u65f6\uff0c\u5173\u8054\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)purchaseHistory.getSpec(), (String)"\u65b0\u589e\u65f6\uff0c\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)purchaseHistory.getUnite(), (String)"\u65b0\u589e\u65f6\uff0c\u9500\u552e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        purchaseHistory.setTimes(1);
        purchaseHistory.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        purchaseHistory.setCreateTime(new Date());
        LoginDetails loginUserDetails = this.loginUserService.getLoginDetails(LoginDetails.class);
        purchaseHistory.setCreateAccount(loginUserDetails.getAccount());
        purchaseHistory.setCreateName(loginUserDetails.getUsername());
        purchaseHistory.setAppCode(TenantUtils.getAppCode());
        Validate.isTrue((purchaseHistory.getGoodsCode().length() <= 64 ? 1 : 0) != 0, (String)"\u8d27\u7269\u7f16\u7801 \u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764", (Object[])new Object[0]);
        Validate.isTrue((purchaseHistory.getGoodsName().length() <= 100 ? 1 : 0) != 0, (String)"\u8d27\u7269\u540d\u79f0 \u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100", (Object[])new Object[0]);
        Validate.isTrue((purchaseHistory.getSpec().length() <= 64 ? 1 : 0) != 0, (String)"\u89c4\u683c \u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764", (Object[])new Object[0]);
        Validate.isTrue((purchaseHistory.getUnite().length() <= 64 ? 1 : 0) != 0, (String)"\u9500\u552e\u5355\u4f4d \u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764", (Object[])new Object[0]);
        Validate.isTrue((purchaseHistory.getRelateCode().length() <= 255 ? 1 : 0) != 0, (String)"\u5173\u8054\u7f16\u7801 \u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255", (Object[])new Object[0]);
    }

    private void updateValidate(PurchaseHistory purchaseHistory) {
        Validate.notNull((Object)((Object)purchaseHistory), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)purchaseHistory.getId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)purchaseHistory.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)purchaseHistory.getAppCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u54c1\u724c\u5546\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

