package com.biz.crm.dms.business.order.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.sdk.service.OrderCloseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 订单关闭控制器
 *
 * @author hefan
 * @date 2022/05/12
 */
@RestController
@RequestMapping("/v1/order/close")
@Slf4j
@Api(tags = "订单模块：void ：订单关闭")
public class OrderCloseController {

  @Autowired(required = false)
  private OrderCloseService orderCloseService;

  /**
   * 处理关闭
   *
   * @param orderCode 指令码
   * @return {@link Result}<{@link ?}>
   */
  @ApiOperation(value = "订单关闭")
  @PatchMapping("handleClose")
  public Result<?> handleClose(@ApiParam(name = "orderCode", value = "订单编码") @RequestParam String orderCode) {
    try {
      log.info("/v1/order/close/handleClose:{}", orderCode);
      this.orderCloseService.handleClose(orderCode);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
