package com.biz.crm.dms.business.order.local.controller;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.sdk.dto.OrderConfirmDto;
import com.biz.crm.dms.business.order.sdk.service.OrderConfirmService;
import com.biz.crm.dms.business.order.sdk.vo.OrderConfirmVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 订单提交确认相关的http接口
 *
 * @author makejava
 * @since 2022-01-08 15:13:04
 */
@RestController
@RequestMapping("/v1/order/confirm")
@Slf4j
@Api(tags = "订单模块：OrderConfirmVo：订单提交确认")
public class OrderConfirmController {

  @Autowired(required = false)
  private OrderConfirmService orderConfirmService;

  /**
   * hf:
   * 订单提交
   * -- 带上结算信息的预览
   *
   * @param order 实体对象
   * @return
   */
  @ApiOperation(value = "订单提交")
  @PostMapping("handleSubmit")
  public Result<OrderConfirmVo> handleSubmit(@ApiParam(name = "order", value = "订单主信息") @RequestBody OrderConfirmDto order) {
    try {
      log.info("/v1/order/confirm/handleSubmit:{}", JSON.toJSONString(order));
      OrderConfirmVo result = this.orderConfirmService.handleSubmit(order, Lists.newArrayList());
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * hf:
   * 订单确认
   * --生成真正的订单了。
   *
   * @param order 实体对象
   * @return
   */
  @ApiOperation(value = "订单确认")
  @PostMapping("handleConfirm")
  public Result<OrderConfirmVo> handleConfirm(@ApiParam(name = "order", value = "订单主信息") @RequestBody OrderConfirmDto order) {
    try {
      log.info("/v1/order/confirm/handleConfirm:{}", JSON.toJSONString(order));
      OrderConfirmVo result = this.orderConfirmService.handleConfirm(order);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据当前登录客户去确认订单
   * --生成真正的订单了。
   *
   * @param order 实体对象
   * @return
   */
  @ApiOperation(value = "根据当前登录客户去确认订单")
  @PostMapping("handleConfirmByCurrentCustomer")
  public Result<OrderConfirmVo> handleConfirmByCurrentCustomer(@ApiParam(name = "order", value = "订单主信息") @RequestBody OrderConfirmDto order) {
    try {
      log.info("/v1/order/confirm/handleConfirmByCurrentCustomer:{}", JSON.toJSONString(order));
      OrderConfirmVo result = this.orderConfirmService.handleConfirmByCurrentCustomer(order);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据当前登录客户使用部分费用提交订单
   * - 不生成真正的订单。
   * - 不校验最终支付
   * @param order 实体对象
   * @return
   */
  @ApiOperation(value = "根据当前登录客户使用部分费用提交订单")
  @PostMapping("handlePartSubmitByCurrentCustomer")
  public Result<OrderConfirmVo> handlePartSubmitByCurrentCustomer(@ApiParam(name = "order", value = "订单主信息") @RequestBody OrderConfirmDto order) {
    try {
      log.info("/v1/order/confirm/handlePartSubmitByCurrentCustomer:{}", JSON.toJSONString(order));
      OrderConfirmVo result = this.orderConfirmService.handlePartSubmitByCurrentCustomer(order);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
