package com.biz.crm.dms.business.order.local.controller;


import com.biz.crm.dms.business.order.local.entity.OrderFile;
import com.biz.crm.dms.business.order.local.service.OrderFileService;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 订单附件信息(OrderFile)表相关的http接口
 *
 * @author makejava
 * @since 2022-01-08 15:13:19
 */
@RestController
@RequestMapping("/v1/orderFile/orderFile")
@Slf4j
@Api(tags = "订单模块：OrderFile：订单附件信息")
public class OrderFileController {
  /**
   * 服务对象
   */
  @Autowired(required = false)
  private OrderFileService orderFileService;

  /**
   * 分页查询所有数据
   *
   * @param pageable  分页对象
   * @param orderFile 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<OrderFile>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                  @ApiParam(name = "orderFile", value = "订单附件信息") OrderFile orderFile) {
    try {
      Page<OrderFile> page = this.orderFileService.findByConditions(pageable, orderFile);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<OrderFile> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      OrderFile orderFile = this.orderFileService.findById(id);
      return Result.ok(orderFile);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param orderFile 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<OrderFile> create(@ApiParam(name = "orderFile", value = "订单附件信息") @RequestBody OrderFile orderFile) {
    try {
      OrderFile result = this.orderFileService.create(orderFile);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param orderFile 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<OrderFile> update(@ApiParam(name = "orderFile", value = "订单附件信息") @RequestBody OrderFile orderFile) {
    try {
      OrderFile result = this.orderFileService.update(orderFile);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> idList) {
    try {
      this.orderFileService.delete(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
