package com.biz.crm.dms.business.order.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.local.service.OrderFlowService;
import com.biz.crm.dms.business.order.sdk.dto.OrderConfirmDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.Getter;
import lombok.Setter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 订单流程控制
 *
 * @author hefan
 */
@RestController
@RequestMapping("/v1/order/flow")
@Getter
@Setter
@Api(tags = "订单模块：Order：订单流程控制")
public class OrderFlowController {

 @Autowired(required = false)
 private OrderFlowService orderFlowService;

 /**
  * 临时接口
  * --要删
  * --不会有任何地方使用
  *
  * @param orderCode
  * @return
  */
 @ApiOperation(value = "临时接口--订单扣减费用")
 @PostMapping("结账")
 public Result<?> pay(OrderConfirmDto orderCode) {
  this.orderFlowService.pay(orderCode);
  return Result.ok();
 }





}
