package com.biz.crm.dms.business.order.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.sdk.service.OrderStatusStatisticsVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderStatusStatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 订单状态统计vo控制器
 *
 * @author hefan
 * @date 2022/04/13
 */
@RestController
@RequestMapping("/v1/order/orderStatusStatistics")
@Slf4j
@Api(tags = "订单模块：OrderStatusStatisticsVo：订单状态统计")
public class OrderStatusStatisticsVoController {

  @Autowired(required = false)
  private OrderStatusStatisticsVoService orderStatusStatisticsVoService;

  /**
   * 根据当前登录经销商统计订单
   *
   * @return {@link Result}<{@link List}<{@link OrderStatusStatisticsVo}>>
   */
  @ApiOperation(value = "根据当前登录经销商统计订单")
  @GetMapping("findByCurrentCustomer")
  public Result<List<OrderStatusStatisticsVo>> findByCurrentCustomer(@RequestParam("customerCode") String customerCode, @RequestParam("customerName") String customerName) {
    try {
      List<OrderStatusStatisticsVo> result = this.orderStatusStatisticsVoService.findByCurrentCustomer(customerCode, customerName);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
