package com.biz.crm.dms.business.order.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.sdk.service.OrderVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/v1/order/order")
@Slf4j
@Api(tags = "订单模块：OrderVo：订单主信息")
public class OrderVoController {

  @Autowired(required = false)
  private OrderVoService orderVoService;

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<OrderVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      OrderVo order = this.orderVoService.findById(id);
      return Result.ok(order);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过 订单编码 查询单条数据
   *
   * @param orderCode 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过 订单编码 查询单条数据")
  @GetMapping("findByOrderCode")
  public Result<OrderVo> findByOrderCode(@ApiParam(name = "orderCode", value = "订单编码") @RequestParam("orderCode") String orderCode) {
    try {
      OrderVo order = this.orderVoService.findByOrderCode(orderCode);
      return Result.ok(order);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
