package com.biz.crm.dms.business.order.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.local.entity.PurchaseHistory;
import com.biz.crm.dms.business.order.local.service.PurchaseHistoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 购买历史(PurchaseHistory)表相关的http接口
 *
 * @author makejava
 * @since 2022-04-07 17:14:33
 */
@RestController
@RequestMapping("/v1/order/purchaseHistory")
@Slf4j
@Api(tags = "订单模块：PurchaseHistory：购买历史记录")
public class PurchaseHistoryController {
  /**
  * 服务对象
  */
  @Autowired(required = false)
  private PurchaseHistoryService purchaseHistoryService;
  
  /**
   * 商品购买次数自增，（原子性)
   *
   * @param purchaseHistoryList 购买历史列表
   * @return 结果
   */
  @ApiOperation(value = "商品购买次数自增，（原子性)")
  @PostMapping
  public Result<List<PurchaseHistory>> handleIncrement(@ApiParam(name = "purchaseHistory", value = "购买历史") @RequestBody List<PurchaseHistory> purchaseHistoryList) {
    try {
      List<PurchaseHistory> result = this.purchaseHistoryService.handleIncrement(purchaseHistoryList);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> idList) {
    try {
      this.purchaseHistoryService.delete(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
