package com.biz.crm.dms.business.order.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.sdk.dto.PurchaseHistoryPageDto;
import com.biz.crm.dms.business.order.sdk.service.PurchaseHistoryVoService;
import com.biz.crm.dms.business.order.sdk.vo.PurchaseHistoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 购买历史(PurchaseHistory)表相关的http接口
 *
 * @author makejava
 * @since 2022-04-07 17:14:33
 */
@RestController
@RequestMapping("/v1/order/purchaseHistory")
@Slf4j
@Api(tags = "订单模块：PurchaseHistoryVo：购买历史记录")
public class PurchaseHistoryVoController {

  @Autowired(required = false)
  private PurchaseHistoryVoService purchaseHistoryVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable        分页对象
   * @param purchaseHistory 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<PurchaseHistoryVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "purchaseHistory", value = "购买历史") PurchaseHistoryPageDto purchaseHistory) {
    try {
      Page<PurchaseHistoryVo> page = this.purchaseHistoryVoService.findByConditions(pageable, purchaseHistory);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
