package com.biz.crm.dms.business.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 订单主信息(Order)实体类
 * 主信息包含：
 * 客户信息
 * 收货信息
 * 结算信息
 *
 * @author sunx
 * @since 2021-12-28 15:18:33
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_order")
@Table(name = "dms_order", indexes = {
    @Index(name = "uk_app_tenant_order", columnList = "app_code,tenant_code,order_code", unique = true)
})
@ApiModel(value = "Order", description = "订单主信息")
@org.hibernate.annotations.Table(appliesTo = "dms_order", comment = "订单主信息")
public class Order extends WorkflowFlagOpEntity {
  private static final long serialVersionUID = -155595187422722814L;

  @ApiModelProperty(
      name = "appCode",
      value = "品牌商租户编号",
      required = true
  )
  @TableField("app_code")
  @Column(
      name = "app_code",
      nullable = false,
      columnDefinition = "varchar(64) COMMENT '品牌商租户编号'"
  )
  private String appCode;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  @TableField(value = "order_code")
  @Column(name = "order_code", length = 255, columnDefinition = "varchar(255) COMMENT '订单编码'")
  private String orderCode;

  /**
   * 原始订单编码
   */
  @ApiModelProperty("原始订单编码")
  @TableField(value = "original_order_code")
  @Column(name = "original_order_code", length = 255, columnDefinition = "varchar(255) COMMENT '原始订单编码'")
  private String originalOrderCode;

  /**
   * 订单来源
   */
  @ApiModelProperty("订单来源")
  @TableField(value = "order_source")
  @Column(name = "order_source", length = 64, columnDefinition = "varchar(64) COMMENT '订单来源'")
  private String orderSource;

  /**
   * 订单类别：销售订单、物料订单
   */
  @ApiModelProperty("订单类别")
  @TableField(value = "order_category")
  @Column(name = "order_category", length = 64, columnDefinition = "varchar(64) COMMENT '订单类别'")
  private String orderCategory;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  @TableField(value = "order_type")
  @Column(name = "order_type", length = 64, columnDefinition = "varchar(64) COMMENT '订单类型'")
  private String orderType;

  /**
   * 订单状态
   */
  @ApiModelProperty("订单状态")
  @TableField(value = "order_status")
  @Column(name = "order_status", length = 64, columnDefinition = "varchar(64) COMMENT '订单状态'")
  private String orderStatus;

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  @TableField(value = "relate_code")
  @Column(name = "relate_code", length = 255, columnDefinition = "varchar(255) COMMENT '关联编码 【客户编码】'")
  private String relateCode;

  /**
   * 关联名称 【客户名称】
   */
  @ApiModelProperty("关联名称 【客户名称】")
  @TableField(value = "relate_name")
  @Column(name = "relate_name", length = 100, columnDefinition = "varchar(100) COMMENT '关联名称 【客户名称】'")
  private String relateName;

  /**
   * 提货方式
   */
  @ApiModelProperty("提货方式")
  @TableField(value = "pick_up_way")
  @Column(name = "pick_up_way", length = 64, columnDefinition = "varchar(64) COMMENT '提货方式'")
  private String pickUpWay;

  /**
   * 收货地址 == 详细地址
   */
  @ApiModelProperty("收货地址 == 详细地址 ")
  @Column(name = "detailed_address", length = 128, columnDefinition = "VARCHAR(128) COMMENT '收货地址 == 详细地址 '")
  private String detailedAddress;

  /**
   * 仓库编码 - 因为物料订单需要指定仓库
   */
  @ApiModelProperty("仓库编码")
  @TableField("warehouse_code")
  @Column(name = "warehouse_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 仓库编码 '")
  private String warehouseCode;

  /**
   * 仓库名称 - 因为物料订单需要指定仓库
   */
  @ApiModelProperty("仓库名称")
  @TableField("warehouse_name")
  @Column(name = "warehouse_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 仓库名称 '")
  private String warehouseName;

  /**
   * 联系人
   */
  @ApiModelProperty("联系人")
  @Column(name = "contact_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '联系人'")
  private String contactName;

  /**
   * 联系方式 == 联系电话
   */
  @ApiModelProperty("联系方式 == 联系电话")
  @Column(name = "contact_phone", length = 64, columnDefinition = "VARCHAR(64) COMMENT '联系方式 == 联系电话'")
  private String contactPhone;

  /**
   * 交货日期
   */
  @ApiModelProperty("交货日期")
  @TableField(value = "delivery_date")
  @Column(name = "delivery_date", columnDefinition = "date COMMENT '交货日期'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date deliveryDate;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  @Column(name = "province_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '省编码'")
  private String provinceCode;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  @Column(name = "city_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '市编码'")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  @Column(name = "district_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区编码'")
  private String districtCode;

  /**
   * 商品数量
   */
  @ApiModelProperty("商品数量")
  @Column(name = "quantity_of_commodity", columnDefinition = "decimal(20,4) COMMENT '商品数量'")
  private BigDecimal quantityOfCommodity;

  /**
   * 发货数量
   */
  @ApiModelProperty("发货数量")
  @Column(name = "delivery_quantity", columnDefinition = "decimal(20,4) COMMENT '发货数量'")
  private BigDecimal deliveryQuantity;

  /**
   * 收货状态
   */
  @ApiModelProperty("收货状态")
  @Column(name = "receipt_status", length = 64, columnDefinition = "varchar(64) COMMENT '收货状态'")
  private String receiptStatus;

  /**
   * 订单总金额
   */
  @ApiModelProperty("订单总金额")
  @Column(name = "total_order_amount", columnDefinition = "decimal(20,4) COMMENT '订单总金额'")
  private BigDecimal totalOrderAmount;

  /**
   * 本单实际支付 == 实际支付金额
   */
  @ApiModelProperty("本单实际支付 == 实际支付金额")
  @Column(name = "actual_amount_paid", columnDefinition = "decimal(20,4) COMMENT '本单实际支付 == 实际支付金额'")
  private BigDecimal actualAmountPaid;

  /**
   * 是否揉价（0：否；1：是）
   */
  @ApiModelProperty("是否揉价（0：否；1：是）")
  @Column(name = "split_price", length = 1, columnDefinition = "bit(1) COMMENT '是否揉价（0：否；1：是）'")
  private Boolean splitPrice;

  /**
   * 暂存的草稿（0：否；1：是）
   */
  @ApiModelProperty("暂存的草稿（0：否；1：是）")
  @Column(name = "draft", length = 1, columnDefinition = "bit(1) COMMENT '暂存的草稿（0：否；1：是）'")
  private Boolean draft;

  /**
   * 期望到货时间
   */
  @ApiModelProperty("期望到货时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @Column(name = "expected_arrival_time", columnDefinition = "date COMMENT '期望到货时间'")
  private Date expectedArrivalTime;

  /**
   * 开票状态
   */
  @ApiModelProperty("开票状态")
  @Column(name = "invoice_status", length = 64, columnDefinition = "varchar(64) COMMENT '开票状态'")
  private String invoiceStatus;

  /**
   * 是否显示 Y代表是 ，N代表否
   * 不填默认Y；
   * 主要是用于外部创建的退货单，例如换货单创建的退货单，在未审批通过时不展示在退货单列表中
   */
  @ApiModelProperty("是否显示")
  @Column(name = "is_show", length = 1, columnDefinition = "char(1) NOT NULL default '1' COMMENT '是否显示'")
  private Boolean isShow;

  /**
   * 外部来源
   * - 比如换货单单号
   */
  @ApiModelProperty("外部来源")
  @Column(name = "external_sources", length = 255, columnDefinition = "varchar(255)  COMMENT '外部来源'")
  private String externalSources;

  /**
   * 订单的总的记账项目
   */
  @ApiModelProperty("订单的总的记账项目")
  @TableField(exist = false)
  @Transient
  private List<OrderPay> orderPays;

  /**
   * 存放订单里的货物
   */
  @ApiModelProperty("订单明细 == 存放订单里的货物")
  @TableField(exist = false)
  @Transient
  private List<OrderDetail> orderDetails;

  /**
   * 订单附件信息
   */
  @ApiModelProperty("订单附件信息")
  @TableField(exist = false)
  @Transient
  private List<OrderFile> orderFiles;
}
