package com.biz.crm.dms.business.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.AppEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 订单明细实体类
 * 存放订单里的货物（商品、物料）
 *
 * @author sunx
 * @since 2021-12-28 15:18:36
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_order_detail")
@Table(name = "dms_order_detail", indexes = {
    @Index(name = "uk_app_tenant_order_detail", columnList = "app_code,tenant_code,order_detail_code", unique = true)
})
@ApiModel(value = "OrderDetail", description = "订单明细")
@org.hibernate.annotations.Table(appliesTo = "dms_order_detail", comment = "订单明细")
public class OrderDetail extends AppEntity {
  private static final long serialVersionUID = 5455700198146835048L;

  /**
   * 明细编码
   */
  @ApiModelProperty("明细编码")
  @Column(name = "order_detail_code", length = 255, columnDefinition = "varchar(255) COMMENT '明细编码'")
  private String orderDetailCode;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  @Column(name = "order_code", length = 255, columnDefinition = "varchar(255) COMMENT '订单编码'")
  private String orderCode;

  /**
   * 明细类型 == 行项目类型
   */
  @ApiModelProperty("明细类型 == 行项目类型")
  @Column(name = "item_type", length = 64, columnDefinition = "varchar(64) COMMENT '明细类型 == 行项目类型'")
  private String itemType;

  /**
   * 行项目类型的特有业务编码：比如：货补商品有个【货补池编号】
   */
  @ApiModelProperty("行项目类型的特有业务编码：比如：货补商品有个【货补池编号】")
  @Column(name = "item_code", length = 64, columnDefinition = "varchar(64) COMMENT '行项目类型的特有业务编码：比如：货补商品有个【货补池编号】'")
  private String itemCode;

  /**
   * 商品/物料编码
   */
  @ApiModelProperty("商品/物料编码")
  @Column(name = "goods_code", length = 64, columnDefinition = "varchar(64) COMMENT '商品/物料编码'")
  private String goodsCode;

  /**
   * 商品/物料名称
   */
  @ApiModelProperty("商品/物料名称")
  @Column(name = "goods_name", length = 100, columnDefinition = "varchar(100) COMMENT '商品/物料名称'")
  private String goodsName;

  /**
   * 成本单价 == 系统预设单价
   */
  @ApiModelProperty("成本单价 == 系统预设单价")
  @TableField(value = "preset_unit_price")
  @Column(name = "preset_unit_price", length = 20, columnDefinition = "decimal(20,4) COMMENT '成本单价 == 系统预设单价'")
  private BigDecimal presetUnitPrice;

  /**
   * 实际单价 = 组内分摊后的单价（正向）
   */
  @ApiModelProperty("实际单价 = 组内分摊后的单价（正向）")
  @TableField(value = "actual_unit_price")
  @Column(name = "actual_unit_price", length = 20, columnDefinition = "decimal(20,4) COMMENT '实际单价 = 组内分摊后的单价（正向）'")
  private BigDecimal actualUnitPrice;

  /**
   * 行内全部分摊后的单价（平均价） = 实际支付金额（全部分摊后）/ 商品数量 （反向）【说明：没有业务性质,只做记录使用，不要参与业务开发】
   */
  @ApiModelProperty("行内全部分摊后的单价（平均价） = 实际支付金额（全部分摊后）/ 商品数量 （反向）")
  @TableField(value = "average_unit_price")
  @Column(name = "average_unit_price", length = 20, columnDefinition = "decimal(20,4) COMMENT '行内全部分摊后的单价（平均价） = 实际支付金额（全部分摊后）/ 商品数量 （反向）'")
  private BigDecimal averageUnitPrice;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  @TableField(value = "spec")
  @Column(name = "spec", length = 64, columnDefinition = "varchar(64) COMMENT '规格'")
  private String spec;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  @TableField(value = "unite")
  @Column(name = "unite", length = 64, columnDefinition = "varchar(64) COMMENT '销售单位'")
  private String unite;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  @TableField(value = "quantity")
  @Column(name = "quantity", length = 20, columnDefinition = "decimal(20,4) COMMENT '数量'")
  private BigDecimal quantity;

  /**
   * 销售金额
   */
  @ApiModelProperty("销售金额")
  @Column(name = "sales_amount", columnDefinition = "decimal(20,4) COMMENT '销售金额'")
  private BigDecimal salesAmount;

  /**
   * 实际支付金额（全部分摊后）== 销售金额 - 优惠金额 - 抵扣金额 （即，最终支付金额）
   */
  @ApiModelProperty("实际支付金额（全部分摊后）== 销售金额 - 优惠金额 - 抵扣金额 （即，最终支付金额）")
  @Column(name = "should_payment_amount", columnDefinition = "decimal(20,4) COMMENT '实际支付金额（全部分摊后）== 销售金额 - 优惠金额 - 抵扣金额 （即，最终支付金额）'")
  private BigDecimal shouldPaymentAmount;

  /**
   * 行上该扣项目
   */
  @ApiModelProperty("订单明细行上该扣金额的项目")
  @TableField(exist = false)
  @Transient
  private List<OrderDetailPay> orderDetailPays;

  /**
   * 订单主信息
   */
  @ApiModelProperty("订单主信息")
  @TableField(exist = false)
  @Transient
  private Order order;
}
